/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.osgi.helpers;

import com.tibco.bw.maven.plugin.osgi.helpers.VersionParser;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.maven.project.MavenProject;

public class ManifestWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File updateManifest(MavenProject project, Manifest mf) throws IOException {
        File mfile = new File(project.getBuild().getDirectory(), "MANIFEST.MF");
        mfile.getParentFile().mkdirs();
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(mfile));){
            mf.write(os);
        }
        return mfile;
    }

    public static void updateManifestVersion(MavenProject project, Manifest mf, String qualifierReplacement) {
        Attributes attributes = mf.getMainAttributes();
        String projectVersion = project.getVersion();
        if (projectVersion.indexOf("-SNAPSHOT") != -1) {
            projectVersion = projectVersion.replace("-SNAPSHOT", ".qualifier");
            projectVersion = ManifestWriter.getManifestVersion(mf, projectVersion, qualifierReplacement);
        }
        attributes.put(Attributes.Name.MANIFEST_VERSION, projectVersion);
        attributes.putValue("Bundle-Version", projectVersion);
    }

    private static String getManifestVersion(Manifest manifest, String version, String qualifierReplacement) {
        return VersionParser.getcalculatedOSGiVersion(version, qualifierReplacement);
    }
}

