/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.process;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.codehaus.plexus.logging.Logger;

public class ProcessExecutor {
    private String executorHome;
    private final Logger logger;
    CountDownLatch latch = new CountDownLatch(1);

    public ProcessExecutor(String executorHome, Logger logger) {
        this.executorHome = executorHome;
        this.logger = logger;
    }

    public Process executeProcess(List<String> params) throws Exception {
        this.logger.debug("Executing command =-> " + params.toString());
        ProcessBuilder builder = new ProcessBuilder(params);
        builder.directory(new File(this.executorHome));
        Process process = builder.start();
        StringBuilder sb = new StringBuilder();
        Runnable input = this.getInputRunnable(process, sb);
        Runnable error = this.getErrorRunnable(process, sb);
        Thread inputThread = new Thread(input);
        Thread errorThread = new Thread(error);
        inputThread.start();
        errorThread.start();
        this.latch.await();
        return process;
    }

    public String executeProcessEngine(List<String> params) throws Exception {
        this.logger.debug("Executing command =-> " + params.toString());
        ProcessBuilder builder = new ProcessBuilder(params);
        builder.directory(new File(this.executorHome));
        Process process = builder.start();
        StringBuilder sb = new StringBuilder();
        Runnable input = this.getInputRunnable(process, sb);
        Runnable error = this.getErrorRunnable(process, sb);
        Thread inputThread = new Thread(input);
        Thread errorThread = new Thread(error);
        inputThread.start();
        errorThread.start();
        int exitValue = process.waitFor();
        this.logger.debug("Executed command with Exit Value " + exitValue);
        return sb.toString();
    }

    private Runnable getErrorRunnable(final Process process, final StringBuilder sb) {
        Runnable error = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    InputStream is = process.getErrorStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception e) {
                    ProcessExecutor.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        return error;
    }

    private Runnable getInputRunnable(final Process process, final StringBuilder sb) {
        Runnable input = new Runnable(){

            @Override
            public void run() {
                try {
                    String line;
                    InputStream is = process.getInputStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    BufferedReader br = new BufferedReader(isr);
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception e) {
                    ProcessExecutor.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        };
        return input;
    }
}

