/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setupenterprise;

import com.tibco.bw.maven.plugin.osgi.helpers.ManifestParser;
import com.tibco.bw.maven.plugin.osgi.helpers.ManifestWriter;
import com.tibco.bw.maven.plugin.osgi.helpers.Version;
import com.tibco.bw.maven.plugin.osgi.helpers.VersionParser;
import com.tibco.bw.maven.plugin.utils.BWModulesParser;
import com.tibco.bw.maven.plugin.utils.BWProjectUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.eclipse.aether.graph.Dependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Mojo(name="bwtestear", defaultPhase=LifecyclePhase.GENERATE_TEST_RESOURCES)
public class BWEARTestPackagerMojo
extends AbstractMojo {
    @Parameter(property="project.build.directory")
    private File outputDirectory;
    @Parameter(property="project.basedir")
    private File projectBasedir;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    ProjectDependenciesResolver resolver;
    private List<File> tempFiles;
    private Manifest manifest;
    JarArchiver jarchiver;
    MavenArchiver archiver;
    protected MavenArchiveConfiguration archiveConfiguration;
    Map<String, String> moduleVersionMap;
    String version;
    protected String[] pluginsToIgnore = null;

    public void execute() throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"BWEARPackager Mojo started ...");
            this.tempFiles = new ArrayList<File>();
            this.jarchiver = new JarArchiver();
            this.archiver = new MavenArchiver();
            this.archiveConfiguration = new MavenArchiveConfiguration();
            this.moduleVersionMap = new HashMap<String, String>();
            this.manifest = ManifestParser.parseManifest(this.projectBasedir);
            ManifestWriter.updateManifestVersion(this.project, this.manifest, "timestamp");
            this.getLog().info((CharSequence)"Updated the Manifest version ");
            this.updateManifestVersion();
            this.getLog().info((CharSequence)"Adding Modules to the EAR file");
            this.addModules();
            this.getLog().info((CharSequence)"Adding EAR Information to the EAR File");
            this.addApplication();
            this.cleanup();
            this.getLog().info((CharSequence)"BWEARPackager Mojo finished execution");
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Failed to create BW EAR Archive ", e1);
        }
    }

    private void addApplication() throws Exception {
        this.getLog().debug((CharSequence)"Adding Application specific files...");
        File metainfFolder = this.getApplicationMetaInf();
        File appManifest = this.addFiletoEAR(metainfFolder);
        File earFile = this.getArchiveFileName();
        this.archiver.setArchiver(this.jarchiver);
        this.addDiagrams();
        this.archiver.setOutputFile(earFile);
        this.jarchiver.setManifest(appManifest);
        this.archiveConfiguration.setManifestFile(appManifest);
        this.archiveConfiguration.setAddMavenDescriptor(true);
        this.archiver.createArchive(this.session, this.project, this.archiveConfiguration);
        this.project.getArtifact().setFile(earFile);
    }

    private void addModules() throws Exception {
        try {
            String dependencyVersion;
            String bwEdition;
            this.getLog().debug((CharSequence)"Adding Modules to the Application EAR");
            this.version = this.manifest.getMainAttributes().getValue("Bundle-Version");
            BWModulesParser parser = new BWModulesParser(this.session, this.project);
            parser.bwEdition = bwEdition = this.manifest.getMainAttributes().getValue("TIBCO-BW-Edition");
            List<Artifact> artifacts = parser.getModulesSet();
            for (Artifact artifact : artifacts) {
                File moduleJar = artifact.getFile();
                Manifest mf = ManifestParser.parseManifestFromJAR(moduleJar);
                if (mf.getMainAttributes().containsKey("TIBCO-BW-SharedModule")) {
                    this.jarchiver.addFile(moduleJar, artifact.getArtifactId() + "_" + artifact.getBaseVersion() + ".jar");
                } else {
                    this.jarchiver.addFile(moduleJar, moduleJar.getName());
                }
                String version = BWProjectUtils.getModuleVersion(moduleJar);
                this.getLog().info((CharSequence)("Adding Module JAR with name " + moduleJar.getName() + " with version " + version));
                this.moduleVersionMap.put(artifact.getArtifactId(), version);
            }
            List<MavenProject> projects = parser.getModulesProjectSet();
            HashSet<File> artifactFiles = new HashSet<File>();
            for (MavenProject project : projects) {
                Set dependencyArtifacts = project.getDependencyArtifacts();
                block4: for (Artifact artifact : dependencyArtifacts) {
                    File f = artifact.getFile();
                    this.getLog().debug((CharSequence)("Dependency file is " + f.getAbsolutePath()));
                    if (this.isPluginToIgnore(f.getName()) || artifact.getVersion().equals("0.0.0") || this.moduleVersionMap.containsKey(artifact.getArtifactId())) continue;
                    dependencyVersion = BWProjectUtils.getModuleVersion(artifact.getFile());
                    Manifest mf = ManifestParser.parseManifestFromJAR(f);
                    for (Object str : mf.getMainAttributes().keySet()) {
                        this.getLog().debug((CharSequence)str.toString());
                        if (!"TIBCO-BW-SharedModule".equals(str.toString())) continue;
                        this.moduleVersionMap.put(artifact.getArtifactId(), dependencyVersion);
                        artifactFiles.add(artifact.getFile());
                        continue block4;
                    }
                }
            }
            DependencyResolutionResult resolutionResult = this.getDependenciesResolutionResult();
            if (resolutionResult != null) {
                block6: for (Dependency dependency : resolutionResult.getDependencies()) {
                    if (dependency.getArtifact().getVersion().equals("0.0.0") || this.moduleVersionMap.containsKey(dependency.getArtifact().getArtifactId())) continue;
                    Manifest mf = ManifestParser.parseManifestFromJAR(dependency.getArtifact().getFile());
                    for (Object str : mf.getMainAttributes().keySet()) {
                        this.getLog().debug((CharSequence)str.toString());
                        if (!"TIBCO-BW-SharedModule".equals(str.toString())) continue;
                        dependencyVersion = BWProjectUtils.getModuleVersion(dependency.getArtifact().getFile());
                        this.moduleVersionMap.put(dependency.getArtifact().getArtifactId(), dependencyVersion);
                        artifactFiles.add(dependency.getArtifact().getFile());
                        continue block6;
                    }
                }
            }
            for (File file : artifactFiles) {
                this.jarchiver.addFile(file, file.getName());
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to add modules to the Application");
            throw e;
        }
    }

    private void addDiagrams() {
        DefaultFileSet fileSet = new DefaultFileSet();
        fileSet.setDirectory(this.projectBasedir);
        if (this.containsDiagrams()) {
            String[] includes = new String[]{"resources/"};
            fileSet.setIncludes(includes);
            this.archiver.getArchiver().addFileSet((FileSet)fileSet);
        }
    }

    private boolean containsDiagrams() {
        return new File(this.projectBasedir, "resources").exists();
    }

    private DependencyResolutionResult getDependenciesResolutionResult() {
        DependencyResolutionResult resolutionResult = null;
        try {
            this.getLog().debug((CharSequence)("Looking up dependency tree for the current project => " + this.project + " and the current session => " + this.session));
            DefaultDependencyResolutionRequest resolution = new DefaultDependencyResolutionRequest(this.project, this.session.getRepositorySession());
            resolutionResult = this.resolver.resolve((DependencyResolutionRequest)resolution);
        }
        catch (DependencyResolutionException e) {
            this.getLog().debug((CharSequence)("Caught DependencyResolutionException for the project => " + e.getMessage() + " with cause => " + e.getCause()));
            e.printStackTrace();
            resolutionResult = e.getResult();
        }
        return resolutionResult;
    }

    protected String[] getPluginsToIgnore() {
        if (this.pluginsToIgnore == null) {
            this.pluginsToIgnore = new String[]{"com.tibco.bw.palette.shared", "com.tibco.xml.cxf.common", "tempbw"};
        }
        return this.pluginsToIgnore;
    }

    protected boolean isPluginToIgnore(String pluginName) {
        for (String toIgnore : this.getPluginsToIgnore()) {
            if (!pluginName.startsWith(toIgnore)) continue;
            return true;
        }
        return false;
    }

    private File getArchiveFileName() {
        Version version = VersionParser.parseVersion(this.manifest.getMainAttributes().getValue("Bundle-Version"));
        String fullVersion = version.getMajor() + "." + version.getMinor() + "." + version.getMicro();
        String archiveName = this.project.getArtifactId() + "_" + fullVersion + ".ear";
        File archiveFile = new File(this.outputDirectory, archiveName);
        this.getLog().info((CharSequence)("The EAR file name for Application is " + archiveFile.toString()));
        return archiveFile;
    }

    private File addFiletoEAR(File metainf) throws Exception {
        File manifestFile = null;
        File[] fileList = metainf.listFiles();
        this.getLog().debug((CharSequence)"Adding files to META-INF folder of EAR. ");
        for (int i = 0; i < fileList.length; ++i) {
            if (fileList[i].getName().indexOf("MANIFEST") != -1) {
                manifestFile = this.getUpdatedManifest(fileList[i]);
                this.jarchiver.addFile(manifestFile, "META-INF/" + fileList[i].getName());
                continue;
            }
            if (fileList[i].getName().indexOf("TIBCO.xml") != -1) {
                File tibcoXML = this.getUpdatedTibcoXML(fileList[i]);
                this.jarchiver.addFile(tibcoXML, "META-INF/" + fileList[i].getName());
                continue;
            }
            if (fileList[i].getName().indexOf(".substvar") == -1) continue;
            this.jarchiver.addFile(fileList[i], "META-INF/" + fileList[i].getName());
        }
        return manifestFile;
    }

    private File getUpdatedManifest(File manifestFile) throws Exception {
        File tempManifest = File.createTempFile("bwear", "mf");
        Attributes attr = this.manifest.getMainAttributes();
        attr.putValue("Bundle-Version", this.version);
        this.getLog().info((CharSequence)("Manifest updated with Version " + this.version));
        FileOutputStream os = new FileOutputStream(tempManifest);
        this.manifest.write(os);
        os.close();
        this.tempFiles.add(tempManifest);
        this.getLog().debug((CharSequence)("Manifest added to temp location at " + tempManifest.toString()));
        return tempManifest;
    }

    private File getApplicationMetaInf() throws Exception {
        File[] fileList = this.projectBasedir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().indexOf("META-INF") != -1;
            }
        });
        return fileList[0];
    }

    private File getUpdatedTibcoXML(File tibcoxML) throws Exception {
        this.getLog().debug((CharSequence)"Updating the TibcoXML file with the module versions ");
        Document doc = this.loadTibcoXML(tibcoxML);
        doc = this.updateTibcoXMLVersion(doc);
        File file = this.saveTibcoXML(doc);
        return file;
    }

    private Document loadTibcoXML(File file) throws Exception {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(file);
        this.getLog().debug((CharSequence)"Loaded Tibco.xml file");
        return doc;
    }

    private Document updateTibcoXMLVersion(Document doc) throws Exception {
        NodeList nList = doc.getElementsByTagNameNS("http://schemas.tibco.com/tra/model/core/PackagingModel", "module");
        for (int i = 0; i < nList.getLength(); ++i) {
            Element node = (Element)nList.item(i);
            NodeList childList = node.getElementsByTagNameNS("http://schemas.tibco.com/tra/model/core/PackagingModel", "symbolicName");
            String module = childList.item(0).getTextContent();
            NodeList technologyVersionList = node.getElementsByTagNameNS("http://schemas.tibco.com/tra/model/core/PackagingModel", "technologyVersion");
            Node technologyVersion = technologyVersionList.item(0);
            technologyVersion.setTextContent(this.moduleVersionMap.get(module));
        }
        this.getLog().debug((CharSequence)"Updated Module versions in the Tibcoxml file");
        return doc;
    }

    private File saveTibcoXML(Document doc) throws Exception {
        File tempXml = File.createTempFile("bwear", "xml");
        doc.getDocumentElement().normalize();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(tempXml);
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        this.tempFiles.add(tempXml);
        this.getLog().debug((CharSequence)("Updated TibcoXML file to temp location " + tempXml.toString()));
        return tempXml;
    }

    private void cleanup() {
        for (File file : this.tempFiles) {
            file.delete();
        }
        this.getLog().debug((CharSequence)"cleaned up the temporary files.");
    }

    private void updateManifestVersion() {
        String version = this.manifest.getMainAttributes().getValue("Bundle-Version");
        String qualifierVersion = VersionParser.getcalculatedOSGiVersion(version, "timestamp");
        this.getLog().info((CharSequence)("The OSGi verion is " + qualifierVersion + " for Maven version of " + version));
        this.manifest.getMainAttributes().putValue("Bundle-Version", qualifierVersion);
    }
}

