/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BWModulesParser {
    private MavenSession session;
    private MavenProject project;
    public String bwEdition;

    public BWModulesParser(MavenSession session, MavenProject project) {
        this.session = session;
        this.project = project;
    }

    public List<Artifact> getModulesSet() {
        ArrayList<Artifact> list = new ArrayList<Artifact>();
        List<String> modules = this.getModulesFromTibcoXML();
        for (String module : modules) {
            Artifact file = this.getArtifactForModule(module);
            if (file == null) continue;
            list.add(file);
        }
        return list;
    }

    public List<MavenProject> getModulesProjectSet() {
        ArrayList<MavenProject> list = new ArrayList<MavenProject>();
        List<String> modules = this.getModulesFromTibcoXML();
        for (String module : modules) {
            MavenProject project = this.getProjectForModule(module);
            if (project == null) continue;
            list.add(project);
        }
        return list;
    }

    private List<String> getModulesFromTibcoXML() {
        ArrayList<String> modules = new ArrayList<String>();
        try {
            File tibcoXML = new File(this.project.getBasedir(), "META-INF/TIBCO.xml");
            NodeList nList = this.getModuleList(tibcoXML);
            for (int i = 0; i < nList.getLength(); ++i) {
                Element node = (Element)nList.item(i);
                NodeList childList = node.getElementsByTagNameNS("http://schemas.tibco.com/tra/model/core/PackagingModel", "symbolicName");
                String module = childList.item(0).getTextContent();
                modules.add(module);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modules;
    }

    private Artifact getArtifactForModule(String module) {
        List projects = new ArrayList();
        projects = this.bwEdition != null && this.bwEdition.equals("bwcf") ? this.session.getAllProjects() : this.session.getProjects();
        Set depArtifacts = this.project.getDependencyArtifacts();
        for (Artifact depArtifact : depArtifacts) {
            if (!depArtifact.getArtifactId().equals(module)) continue;
            return depArtifact;
        }
        for (MavenProject project : projects) {
            if (!project.getArtifactId().equals(module)) continue;
            Artifact artifact = project.getArtifact();
            return artifact;
        }
        return null;
    }

    private MavenProject getProjectForModule(String module) {
        List projects = new ArrayList();
        projects = this.bwEdition != null && this.bwEdition.equals("bwcf") ? this.session.getAllProjects() : this.session.getProjects();
        for (MavenProject project : projects) {
            if (!project.getArtifactId().equals(module)) continue;
            return project;
        }
        return null;
    }

    private NodeList getModuleList(File tibcoXML) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setNamespaceAware(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.parse(tibcoXML);
        NodeList nList = doc.getElementsByTagNameNS("http://schemas.tibco.com/tra/model/core/PackagingModel", "module");
        return nList;
    }
}

