/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.test.helpers.BWMFileParser;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.helpers.TestFileParser;
import com.tibco.bw.maven.plugin.test.rest.BWTestRunner;
import com.tibco.bw.maven.plugin.test.setuplocal.ConfigFileGenerator;
import com.tibco.bw.maven.plugin.test.setuplocal.ESMTestFile;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineLaunchConfigurator;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineRunner;
import com.tibco.bw.maven.plugin.testsuite.BWTestSuiteLoader;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;

public class BWTestExecutor {
    public static BWTestExecutor INSTANCE = new BWTestExecutor();
    int engineDebugPort;
    int engineStartupWaitTime;
    List<String> osgiCommands;
    boolean skipInitMainProcessActivities;
    boolean skipInitAllNonTestProcessActivities;
    String customArgEngine;
    MavenSession session;
    ProjectDependenciesResolver resolver;
    List<String> mockActivity = new ArrayList<String>();

    public BWTestExecutor() {
    }

    public BWTestExecutor(MavenSession session, ProjectDependenciesResolver resolver) {
        this.session = session;
        this.resolver = resolver;
    }

    public void execute() throws MojoFailureException, Exception {
        try {
            this.initialize();
            this.runEngine();
            this.runTests();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (BWTestConfig.INSTANCE.getEngineProcess() != null) {
                BWTestConfig.INSTANCE.getEngineProcess().destroyForcibly();
            }
            if (BWTestConfig.INSTANCE.getConfigDir() != null) {
                BWTestConfig.INSTANCE.getConfigDir().delete();
            }
            if (BWTestConfig.INSTANCE.getESMDirectories() != null) {
                for (File ESMDirectory : BWTestConfig.INSTANCE.getESMDirectories()) {
                    FileUtils.cleanDirectory((File)ESMDirectory);
                    ESMDirectory.delete();
                }
            }
        }
    }

    public void collectSkipInitActivityName() throws Exception, FileNotFoundException {
        String assertionxml;
        HashSet<Object> tempSkipSet;
        HashMap<String, Boolean> userTestSuiteNames;
        List projects = BWTestConfig.INSTANCE.getSession().getProjects();
        if (BWTestConfig.INSTANCE.getRunESMTest()) {
            ESMTestFile esmTestFile = new ESMTestFile();
            esmTestFile.extractESM();
        }
        if (null != BWTestConfig.INSTANCE.getTestSuiteName() && !BWTestConfig.INSTANCE.getTestSuiteName().isEmpty()) {
            String[] testSuiteNames = BWTestConfig.INSTANCE.getTestSuiteName().contains(";") ? StringUtils.splitByWholeSeparator((String)BWTestConfig.INSTANCE.getTestSuiteName(), (String)";") : new String[]{BWTestConfig.INSTANCE.getTestSuiteName()};
            userTestSuiteNames = new HashMap();
            for (String string : testSuiteNames) {
                userTestSuiteNames.put(string, false);
            }
            BWTestConfig.INSTANCE.setUserTestSuiteNames((Map<String, Boolean>)userTestSuiteNames);
        }
        for (MavenProject project : projects) {
            String[] files;
            if (!project.getPackaging().equals("bwmodule")) continue;
            File baseDir = project.getBasedir();
            if (!BWTestConfig.INSTANCE.getUserTestSuiteNames().isEmpty()) {
                BWTestSuiteLoader testSuiteLoader = new BWTestSuiteLoader();
                files = testSuiteLoader.collectTestCasesList(baseDir.toString(), project);
            } else {
                files = BWFileUtils.getEntitiesfromLocation(baseDir.toString(), "bwt");
            }
            BWTestConfig.INSTANCE.setTestCasesList(project, (List<File>)files);
            for (File file : files) {
                tempSkipSet = new HashSet();
                assertionxml = FileUtils.readFileToString((File)file);
                tempSkipSet = TestFileParser.INSTANCE.collectSkipInitActivities(assertionxml);
                if (tempSkipSet.isEmpty()) continue;
                this.mockActivity.addAll(tempSkipSet);
                INSTANCE.setMockActivityList(this.mockActivity);
            }
            List<File> bwmfiles = BWFileUtils.getEntitiesfromLocation(baseDir.toString(), "bwm");
            for (File file3 : bwmfiles) {
                BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Parsing bwm file -> " + file3.getPath()));
                HashSet<Object> tempSkipSet2 = new HashSet();
                String scaxml = FileUtils.readFileToString((File)file3);
                tempSkipSet2 = BWMFileParser.INSTANCE.collectMainProcesses(scaxml);
                if (tempSkipSet2.isEmpty()) continue;
                this.mockActivity.addAll(tempSkipSet2);
                INSTANCE.setMockActivityList(this.mockActivity);
            }
        }
        if (BWTestConfig.INSTANCE.getRunESMTest() && null != BWTestConfig.INSTANCE.getEsmTestSuiteName() && !BWTestConfig.INSTANCE.getEsmTestSuiteName().isEmpty()) {
            String[] esmTestSuiteNames = BWTestConfig.INSTANCE.getEsmTestSuiteName().contains("/") ? StringUtils.splitByWholeSeparator((String)BWTestConfig.INSTANCE.getEsmTestSuiteName(), (String)"/") : new String[]{BWTestConfig.INSTANCE.getEsmTestSuiteName()};
            userTestSuiteNames = new HashMap<String, Boolean>();
            for (String string : esmTestSuiteNames) {
                userTestSuiteNames.put(string, false);
            }
            BWTestConfig.INSTANCE.setUserESMTestSuiteNames(userTestSuiteNames);
        }
        if (BWTestConfig.INSTANCE.getRunESMTest()) {
            List<File> ESMbwtFiles = null;
            for (File esmFile : BWTestConfig.INSTANCE.getESMDirectories()) {
                HashMap<String, Map<String, List<File>>> testSuiteMap;
                String esmProjectPath = esmFile.getAbsolutePath();
                if (!BWTestConfig.INSTANCE.getUserESMTestSuiteNames().isEmpty()) {
                    BWTestSuiteLoader testSuiteLoader = new BWTestSuiteLoader();
                    ESMbwtFiles = testSuiteLoader.collectTestCasesListFromESM(esmProjectPath);
                } else {
                    ESMbwtFiles = BWFileUtils.getEntitiesfromLocation(esmProjectPath, "bwt");
                    BWTestConfig.INSTANCE.setEsmTestCasesList(esmProjectPath, ESMbwtFiles);
                }
                if (null != ESMbwtFiles && ESMbwtFiles.isEmpty() && null == (testSuiteMap = BWTestConfig.INSTANCE.getEsmTestSuites()).get(esmFile)) {
                    ESMbwtFiles = BWFileUtils.getEntitiesfromLocation(esmProjectPath, "bwt");
                    BWTestConfig.INSTANCE.setEsmTestCasesList(esmProjectPath, ESMbwtFiles);
                }
                for (File file : ESMbwtFiles) {
                    tempSkipSet = new HashSet();
                    assertionxml = FileUtils.readFileToString((File)file);
                    tempSkipSet = TestFileParser.INSTANCE.collectSkipInitActivities(assertionxml);
                    if (tempSkipSet.isEmpty()) continue;
                    this.mockActivity.addAll(tempSkipSet);
                    INSTANCE.setMockActivityList(this.mockActivity);
                }
            }
        }
        if (BWTestConfig.INSTANCE.getUserTestSuiteNames().containsValue(false)) {
            for (Map.Entry<String, Boolean> testSuite : BWTestConfig.INSTANCE.getUserTestSuiteNames().entrySet()) {
                if (testSuite.getValue().booleanValue()) continue;
                throw new Exception("Test Suite not found - " + testSuite.getKey());
            }
        }
    }

    private void initialize() throws Exception {
        this.collectSkipInitActivityName();
        EngineLaunchConfigurator config = new EngineLaunchConfigurator();
        config.loadConfiguration();
        ConfigFileGenerator gen = new ConfigFileGenerator(this.session, this.resolver);
        gen.generateConfig();
    }

    private void runEngine() throws Exception {
        EngineRunner runner = new EngineRunner(INSTANCE.getEngineStartupWaitTime(), INSTANCE.getOsgiCommands());
        runner.run();
    }

    private void runTests() throws MojoFailureException, Exception {
        BWTestRunner runner = new BWTestRunner("localhost", INSTANCE.getEngineDebugPort());
        runner.runTests();
    }

    public void setEngineDebugPort(int engineDebugPort) {
        this.engineDebugPort = engineDebugPort;
    }

    public int getEngineDebugPort() {
        return this.engineDebugPort;
    }

    public List<String> getMockActivityList() {
        return this.mockActivity;
    }

    public void setMockActivityList(List<String> mockActivity) {
        this.mockActivity.addAll(mockActivity);
    }

    public int getEngineStartupWaitTime() {
        return this.engineStartupWaitTime;
    }

    public void setEngineStartupWaitTime(int engineStartupWaitTime) {
        this.engineStartupWaitTime = engineStartupWaitTime;
    }

    public List<String> getOsgiCommands() {
        return this.osgiCommands;
    }

    public void setOsgiCommands(List<String> osgiCommands) {
        this.osgiCommands = osgiCommands;
    }

    public boolean isSkipInitMainProcessActivities() {
        return this.skipInitMainProcessActivities;
    }

    public void setSkipInitMainProcessActivities(boolean skipInitMainProcessActivities) {
        this.skipInitMainProcessActivities = skipInitMainProcessActivities;
    }

    public boolean isSkipInitAllNonTestProcessActivities() {
        return this.skipInitAllNonTestProcessActivities;
    }

    public void setSkipInitAllNonTestProcessActivities(boolean skipInitAllNonTestProcessActivities) {
        this.skipInitAllNonTestProcessActivities = skipInitAllNonTestProcessActivities;
    }

    public String getCustomArgEngine() {
        return this.customArgEngine;
    }

    public void setCustomArgEngine(String customArgEngine) {
        this.customArgEngine = customArgEngine;
    }
}

