/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.setuplocal.BWTestExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.ProcessingException;

public class EngineLaunchConfigurator {
    public void loadConfiguration() throws Exception {
        List<String> list;
        List<String> customPropertyList = null;
        BufferedReader reader = this.readEnvFile();
        List<String> result = null;
        String customEnginePropertyFile = BWTestExecutor.INSTANCE.getCustomArgEngine();
        if (null != customEnginePropertyFile && !customEnginePropertyFile.isEmpty()) {
            BufferedReader proertyReader = null;
            try {
                URL url = new File(customEnginePropertyFile).toURI().toURL();
                proertyReader = new BufferedReader(new InputStreamReader(url.openStream()));
            }
            catch (MalformedURLException ex) {
                File file = new File(customEnginePropertyFile);
                if (!file.isAbsolute()) {
                    customEnginePropertyFile = BWTestConfig.INSTANCE.getProject().getBasedir().getAbsolutePath().concat(file.getPath());
                }
                if (new File(customEnginePropertyFile).exists()) {
                    proertyReader = new BufferedReader(new FileReader(customEnginePropertyFile));
                }
                throw new Exception("File Not Found " + customEnginePropertyFile);
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw e;
            }
            customPropertyList = this.readArguments(proertyReader, null);
        }
        if (reader == null) {
            throw new Exception();
        }
        result = list = this.readArguments(reader, customPropertyList);
        BWTestConfig.INSTANCE.setLaunchConfig(result);
    }

    private BufferedReader readEnvFile() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream stream = null;
        stream = this.isWindowsOS() ? classLoader.getResourceAsStream("com/tibco/resources/win_environment.properties") : (this.isMacOS() ? classLoader.getResourceAsStream("com/tibco/resources/mac_environment.properties") : classLoader.getResourceAsStream("com/tibco/resources/unix_environment.properties"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        return reader;
    }

    private boolean isWindowsOS() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("windows");
    }

    private boolean isMacOS() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("mac");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readArguments(BufferedReader reader, List<String> customPropertyList) {
        String currentUsersHomeDir = System.getProperty("user.home");
        File file = new File(currentUsersHomeDir + "/bwutdev.properties");
        boolean isDev = file.exists();
        File custom_Java = new File(currentUsersHomeDir + "/customJavaPath.properties");
        boolean isCustomjava = custom_Java.exists();
        ArrayList<String> list = new ArrayList<String>();
        try {
            String currentLine;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.startsWith("#")) continue;
                if (currentLine.contains("%%TIBCO_HOME%%")) {
                    if (isCustomjava && currentLine.contains("tibcojre")) {
                        Properties prop = new Properties();
                        prop.load(new FileInputStream(custom_Java));
                        Object customJavaPath = prop.get("customJavaPath");
                        currentLine = customJavaPath.toString();
                    } else {
                        currentLine = currentLine.replace("%%TIBCO_HOME%%", BWTestConfig.INSTANCE.getTibcoHome());
                    }
                }
                if (currentLine.contains("%%BW_HOME%%")) {
                    currentLine = currentLine.replace("%%BW_HOME%%", BWTestConfig.INSTANCE.getBwHome());
                    if (!BWTestExecutor.INSTANCE.getMockActivityList().isEmpty()) {
                        list.addAll(BWTestExecutor.INSTANCE.getMockActivityList());
                        BWTestExecutor.INSTANCE.getMockActivityList().clear();
                    }
                    if (BWTestExecutor.INSTANCE.isSkipInitMainProcessActivities()) {
                        list.add("-Dbw.unittest.skipinit.mainprocessactivities=true");
                    }
                    if (BWTestExecutor.INSTANCE.isSkipInitAllNonTestProcessActivities()) {
                        list.add("-Dbw.unittest.skipinit.allnontestprocessactivities=true");
                    }
                }
                if (currentLine.contains("%%CONFIG_DIR%%")) {
                    currentLine = currentLine.replace("%%CONFIG_DIR%%", BWTestConfig.INSTANCE.getConfigDir().toString().replace("\\", "/"));
                }
                if (currentLine.contains("%%ENGINE_DEBUG_PORT%%")) {
                    currentLine = currentLine.replace("%%ENGINE_DEBUG_PORT%%", String.valueOf(BWTestExecutor.INSTANCE.getEngineDebugPort()));
                }
                if (currentLine.equals("-dev")) {
                    if (isDev) {
                        list.add(currentLine);
                        list.add("file:" + file.toString());
                        continue;
                    }
                    list.add(currentLine);
                    list.add("file:" + BWTestConfig.INSTANCE.getConfigDir().toString().replace("\\", "/") + "/dev.properties");
                    continue;
                }
                if (currentLine.equals("-classpath") && customPropertyList != null && !customPropertyList.isEmpty()) {
                    list.addAll(customPropertyList);
                }
                list.add(currentLine);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

