/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.testsuite;

import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.testsuite.BWTSModel;
import com.tibco.bw.maven.plugin.testsuite.YMLBWTSFileReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

public class BWTSFileReaderWrapper {
    public List<File> readBWTSFile(List<String> testSuiteList, String TestFolderPath, MavenProject project, String testFoldername) throws IOException {
        ArrayList<File> returnList = new ArrayList<File>();
        HashMap<String, List<File>> testSuiteMap = new HashMap<String, List<File>>();
        try {
            for (String testSuiteName : testSuiteList) {
                Path path = Paths.get(testSuiteName, new String[0]);
                BWTSModel bwtsModel = YMLBWTSFileReader.getModelFrom(path);
                Object testCaseList = bwtsModel.getOthers().get("testCases");
                ArrayList<File> tempReturnList = new ArrayList<File>();
                String[] locationArray = TestFolderPath.split(testFoldername);
                if (null != testCaseList) {
                    for (Object obj : (ArrayList)testCaseList) {
                        if (!(obj instanceof String)) continue;
                        String location = locationArray[0] + testFoldername + File.separator + (String)obj;
                        returnList.add(new File(location));
                        tempReturnList.add(new File(location));
                    }
                }
                String testSuite = StringUtils.substringAfter((String)testSuiteName, (String)"//");
                testSuiteMap.put(testSuite, tempReturnList);
            }
            BWTestConfig.INSTANCE.setTestSuiteMap(project, testSuiteMap);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return returnList;
    }

    public List<File> readBWTSFileFromESM(List<String> testSuiteList, String TestFolderPath, String esmDir) throws IOException {
        ArrayList<File> returnList = new ArrayList<File>();
        HashMap<String, List<File>> testSuiteMap = new HashMap<String, List<File>>();
        try {
            for (String testSuiteName : testSuiteList) {
                Path path = Paths.get(testSuiteName, new String[0]);
                BWTSModel bwtsModel = YMLBWTSFileReader.getModelFrom(path);
                Object testCaseList = bwtsModel.getOthers().get("testCases");
                ArrayList<File> tempReturnList = new ArrayList<File>();
                if (null != testCaseList) {
                    for (Object obj : (ArrayList)testCaseList) {
                        if (!(obj instanceof String)) continue;
                        returnList.add(new File(TestFolderPath.concat("//" + (String)obj)));
                        tempReturnList.add(new File(TestFolderPath.concat("//" + (String)obj)));
                    }
                }
                String testSuite = StringUtils.substringAfter((String)testSuiteName, (String)TestFolderPath.concat("//"));
                testSuiteMap.put(testSuite, tempReturnList);
            }
            BWTestConfig.INSTANCE.setEsmTestSuiteMap(esmDir, testSuiteMap);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return returnList;
    }
}

