/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem.deployment;

import com.tietoevry.quarkus.resteasy.problem.deployment.ExceptionMapperDefinition;
import com.tietoevry.quarkus.resteasy.problem.deployment.JacksonDetector;
import com.tietoevry.quarkus.resteasy.problem.deployment.JsonBDetector;
import com.tietoevry.quarkus.resteasy.problem.deployment.ProblemBuildConfig;
import com.tietoevry.quarkus.resteasy.problem.deployment.QuarkusSmallryeMetricsDetector;
import com.tietoevry.quarkus.resteasy.problem.deployment.RestEasyClassicDetector;
import com.tietoevry.quarkus.resteasy.problem.deployment.RestEasyReactiveDetector;
import com.tietoevry.quarkus.resteasy.problem.postprocessing.ProblemRecorder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.jsonb.spi.JsonbSerializerBuildItem;
import io.quarkus.resteasy.common.spi.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.reactive.spi.ExceptionMapperBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProblemProcessor {
    private static final String FEATURE_NAME = "resteasy-problem";
    private static final String EXTENSION_MAIN_PACKAGE = "com.tietoevry.quarkus.resteasy.problem.";
    private static final List<String> RESTEASY_JSON_CAPABILITIES = Arrays.asList("io.quarkus.resteasy.json", "io.quarkus.resteasy-json", "io.quarkus.jsonb", "io.quarkus.jackson");

    private static List<ExceptionMapperDefinition> neededExceptionMappers() {
        Stream<ExceptionMapperDefinition> allMappers = Stream.of(ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.HttpProblemMapper").thatHandles("com.tietoevry.quarkus.resteasy.problem.HttpProblem"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jaxrs.WebApplicationExceptionMapper").thatHandles("javax.ws.rs.WebApplicationException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jaxrs.JaxRsForbiddenExceptionMapper").thatHandles("javax.ws.rs.ForbiddenException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jaxrs.NotFoundExceptionMapper").thatHandles("javax.ws.rs.NotFoundException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jsonb.RestEasyClassicJsonbExceptionMapper").thatHandles("javax.ws.rs.ProcessingException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.security.UnauthorizedExceptionMapper").thatHandles("io.quarkus.security.UnauthorizedException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.security.AuthenticationFailedExceptionMapper").thatHandles("io.quarkus.security.AuthenticationFailedException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.security.AuthenticationRedirectExceptionMapper").thatHandles("io.quarkus.security.AuthenticationRedirectException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.security.AuthenticationCompletionExceptionMapper").thatHandles("io.quarkus.security.AuthenticationCompletionException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.security.ForbiddenExceptionMapper").thatHandles("io.quarkus.security.ForbiddenException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.validation.ValidationExceptionMapper").thatHandles("javax.validation.ValidationException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.validation.ConstraintViolationExceptionMapper").thatHandles("javax.validation.ConstraintViolationException"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jackson.JsonProcessingExceptionMapper").thatHandles("com.fasterxml.jackson.core.JsonProcessingException").onlyIf(new JacksonDetector()), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jackson.UnrecognizedPropertyExceptionMapper").thatHandles("com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException").onlyIf(new JacksonDetector()), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jackson.InvalidFormatExceptionMapper").thatHandles("com.fasterxml.jackson.databind.exc.InvalidFormatException").onlyIf(new JacksonDetector()), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jsonb.RestEasyClassicJsonbExceptionMapper").thatHandles("javax.ws.rs.ProcessingException").onlyIf(new JsonBDetector()), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.jsonb.JsonbExceptionMapper").thatHandles("javax.json.bind.JsonbException").onlyIf(new JsonBDetector()), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.ZalandoProblemMapper").thatHandles("org.zalando.problem.ThrowableProblem"), ExceptionMapperDefinition.mapper("com.tietoevry.quarkus.resteasy.problem.DefaultExceptionMapper").thatHandles("java.lang.Exception"));
        return allMappers.filter(ExceptionMapperDefinition::isNeeded).collect(Collectors.toList());
    }

    @BuildStep
    FeatureBuildItem createFeature(Capabilities capabilities) {
        if (RESTEASY_JSON_CAPABILITIES.stream().noneMatch(arg_0 -> ((Capabilities)capabilities).isCapabilityPresent(arg_0))) {
            this.logger().error("`quarkus-resteasy-problem` extension is useless without RESTeasy Json Provider. Please add `quarkus-resteasy-jackson` or `quarkus-resteasy-jsonb` (or reactive versions) to your pom.xml.");
        }
        return new FeatureBuildItem(FEATURE_NAME);
    }

    @BuildStep(onlyIf={RestEasyClassicDetector.class})
    void registerMappersForClassic(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        ProblemProcessor.neededExceptionMappers().forEach(mapper -> providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(mapper.mapperClassName)));
    }

    @BuildStep(onlyIf={RestEasyReactiveDetector.class})
    void registerMappersForReactive(BuildProducer<ExceptionMapperBuildItem> providers) {
        ProblemProcessor.neededExceptionMappers().forEach(mapper -> providers.produce((BuildItem)new ExceptionMapperBuildItem(mapper.mapperClassName, mapper.exceptionClassName, Integer.valueOf(999), true)));
    }

    @BuildStep(onlyIf={JacksonDetector.class})
    void registerJacksonItems(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{"com.tietoevry.quarkus.resteasy.problem.jackson.JacksonProblemModuleRegistrar"}));
    }

    @BuildStep(onlyIf={JsonBDetector.class})
    void registerJsonbItems(BuildProducer<JsonbSerializerBuildItem> serializers) {
        serializers.produce((BuildItem)new JsonbSerializerBuildItem("com.tietoevry.quarkus.resteasy.problem.jsonb.JsonbProblemSerializer"));
    }

    @BuildStep
    ReflectiveClassBuildItem registerPojosForReflection() {
        return new ReflectiveClassBuildItem(true, true, new String[]{"com.tietoevry.quarkus.resteasy.problem.validation.Violation"});
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    void resetRecorder(ProblemRecorder recorder, LiveReloadBuildItem liveReload) {
        if (liveReload.isLiveReload()) {
            recorder.reset();
        }
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void setupMdc(ProblemRecorder recorder, ProblemBuildConfig config) {
        recorder.configureMdc(config.includeMdcProperties);
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep(onlyIf={QuarkusSmallryeMetricsDetector.class})
    void setupMetrics(ProblemRecorder recorder, ProblemBuildConfig config) {
        if (config.metricsEnabled) {
            recorder.enableMetrics();
        }
    }

    @BuildStep(onlyIfNot={QuarkusSmallryeMetricsDetector.class})
    void warnOnMissingSmallryeMetricsDependency(ProblemBuildConfig config) {
        if (config.metricsEnabled) {
            this.logger().warn("quarkus.resteasy.problem.metrics.enabled is set to true, but quarkus-smallrye-metrics not found in the classpath");
        }
    }

    protected Logger logger() {
        return LoggerFactory.getLogger((String)FEATURE_NAME);
    }
}

