/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem;

import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import com.tietoevry.quarkus.resteasy.problem.postprocessing.PostProcessorsRegistry;
import com.tietoevry.quarkus.resteasy.problem.postprocessing.ProblemContext;
import java.util.Objects;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;

public abstract class ExceptionMapperBase<E extends Throwable>
implements ExceptionMapper<E> {
    public static final PostProcessorsRegistry postProcessorsRegistry = new PostProcessorsRegistry();
    @Context
    UriInfo uriInfo;

    public final Response toResponse(E exception) {
        HttpProblem problem = this.toProblem(exception);
        Objects.requireNonNull(problem.getStatus(), "Status must not be null");
        ProblemContext context = ProblemContext.of(exception, this.uriInfo);
        HttpProblem finalProblem = postProcessorsRegistry.applyPostProcessing(problem, context);
        return this.toFinalResponse(finalProblem);
    }

    protected abstract HttpProblem toProblem(E var1);

    private Response toFinalResponse(HttpProblem problem) {
        Objects.requireNonNull(problem.getStatus());
        Response.ResponseBuilder builder = Response.status((int)problem.getStatus().getStatusCode()).type(HttpProblem.MEDIA_TYPE).entity((Object)problem);
        problem.getHeaders().forEach((arg_0, arg_1) -> ((Response.ResponseBuilder)builder).header(arg_0, arg_1));
        return builder.build();
    }
}

