/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem;

import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import com.tietoevry.quarkus.resteasy.problem.postprocessing.PostProcessorsRegistry;
import com.tietoevry.quarkus.resteasy.problem.postprocessing.ProblemContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ExceptionMapper;

public abstract class ExceptionMapperBase<E extends Throwable>
implements ExceptionMapper<E> {
    public static final PostProcessorsRegistry postProcessorsRegistry = new PostProcessorsRegistry();
    @Context
    UriInfo uriInfo;

    public final Response toResponse(E exception) {
        HttpProblem problem = this.toProblem(exception);
        ProblemContext context = ProblemContext.of(exception, this.uriInfo);
        HttpProblem finalProblem = postProcessorsRegistry.applyPostProcessing(problem, context);
        return finalProblem.toResponse();
    }

    protected abstract HttpProblem toProblem(E var1);
}

