/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem;

import com.tietoevry.quarkus.resteasy.problem.ExceptionMapperBase;
import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.Response;
import java.util.Optional;
import org.zalando.problem.ThrowableProblem;

@Priority(value=5000)
public final class ZalandoProblemMapper
extends ExceptionMapperBase<ThrowableProblem> {
    @Override
    protected HttpProblem toProblem(ThrowableProblem exception) {
        Response.StatusType status = (Response.StatusType)Optional.ofNullable(exception.getStatus()).map(problemStatus -> Response.Status.fromStatusCode((int)problemStatus.getStatusCode())).orElse(Response.Status.INTERNAL_SERVER_ERROR);
        HttpProblem.Builder builder = HttpProblem.builder().withType(exception.getType()).withTitle(exception.getTitle()).withStatus(status).withDetail(exception.getDetail()).withInstance(exception.getInstance());
        exception.getParameters().forEach(builder::with);
        return builder.build();
    }
}

