/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem.jackson;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.tietoevry.quarkus.resteasy.problem.ExceptionMapperBase;
import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import jakarta.annotation.Priority;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;

@Priority(value=5000)
public final class InvalidFormatExceptionMapper
extends ExceptionMapperBase<InvalidFormatException> {
    @Override
    protected HttpProblem toProblem(InvalidFormatException exception) {
        return HttpProblem.builder().withStatus((Response.StatusType)Response.Status.BAD_REQUEST).withTitle(Response.Status.BAD_REQUEST.getReasonPhrase()).withDetail(exception.getOriginalMessage()).with("field", this.serializePath(exception.getPath())).build();
    }

    private String serializePath(List<JsonMappingException.Reference> path) {
        String pathString = path.stream().map(this::refToString).collect(Collectors.joining());
        return this.removeFirstDot(pathString);
    }

    private String refToString(JsonMappingException.Reference ref) {
        if (ref.getFieldName() != null) {
            return "." + ref.getFieldName();
        }
        if (ref.getIndex() >= 0) {
            return "[" + ref.getIndex() + "]";
        }
        return ".?";
    }

    private String removeFirstDot(String field) {
        if (field.length() > 1) {
            return field.substring(1);
        }
        return "?";
    }
}

