/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem.jaxrs;

import com.tietoevry.quarkus.resteasy.problem.ExceptionMapperBase;
import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

@Priority(value=5000)
public final class WebApplicationExceptionMapper
extends ExceptionMapperBase<WebApplicationException> {
    @Override
    protected HttpProblem toProblem(WebApplicationException exception) {
        Response.Status status = Response.Status.fromStatusCode((int)exception.getResponse().getStatus());
        HttpProblem.Builder problem = HttpProblem.builder().withTitle(status.getReasonPhrase()).withStatus((Response.StatusType)status).withDetail(exception.getMessage());
        exception.getResponse().getHeaders().forEach((header, values) -> values.forEach(value -> problem.withHeader((String)header, value)));
        return problem.build();
    }
}

