/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem.security;

import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.ws.rs.core.Response;

final class HttpUnauthorizedUtils {
    HttpUnauthorizedUtils() {
    }

    static Uni<HttpProblem> toProblem(RoutingContext routingContext, Exception exception) {
        return HttpUnauthorizedUtils.extractChallenge(routingContext).onItemOrFailure().transform((challenge, e) -> {
            if (challenge == null) {
                return HttpProblem.builder().withTitle(Response.Status.UNAUTHORIZED.getReasonPhrase()).withStatus((Response.StatusType)Response.Status.UNAUTHORIZED).withDetail(exception.getMessage()).build();
            }
            Response.Status status = Response.Status.fromStatusCode((int)challenge.status);
            HttpProblem.Builder builder = HttpProblem.builder().withStatus((Response.StatusType)status).withTitle(status.getReasonPhrase());
            if (challenge.headerName != null) {
                builder = builder.withHeader(challenge.headerName.toString(), challenge.headerContent);
            }
            return builder.build();
        });
    }

    private static Uni<ChallengeData> extractChallenge(RoutingContext routingContext) {
        if (routingContext == null) {
            return Uni.createFrom().nullItem();
        }
        HttpAuthenticator authenticator = (HttpAuthenticator)routingContext.get(HttpAuthenticator.class.getName());
        if (authenticator == null) {
            return Uni.createFrom().nullItem();
        }
        return authenticator.getChallenge(routingContext).onFailure().recoverWithUni(Uni.createFrom().nullItem());
    }
}

