/*
 * Decompiled with CFR 0.152.
 */
package com.tietoevry.quarkus.resteasy.problem.validation;

import com.tietoevry.quarkus.resteasy.problem.ExceptionMapperBase;
import com.tietoevry.quarkus.resteasy.problem.HttpProblem;
import com.tietoevry.quarkus.resteasy.problem.ProblemRuntimeConfig;
import com.tietoevry.quarkus.resteasy.problem.validation.Violation;
import jakarta.annotation.Priority;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Path;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Priority(value=5000)
public final class ConstraintViolationExceptionMapper
extends ExceptionMapperBase<ConstraintViolationException> {
    private static ProblemRuntimeConfig.ConstraintViolationMapperConfig config = ProblemRuntimeConfig.ConstraintViolationMapperConfig.defaults();
    @Context
    ResourceInfo resourceInfo;

    public static void configure(ProblemRuntimeConfig.ConstraintViolationMapperConfig config) {
        ConstraintViolationExceptionMapper.config = config;
    }

    @Override
    protected HttpProblem toProblem(ConstraintViolationException exception) {
        return HttpProblem.builder().withStatus(config.status()).withTitle(config.title()).with("violations", this.toViolations(exception.getConstraintViolations())).build();
    }

    private List<Violation> toViolations(Set<ConstraintViolation<?>> constraintViolations) {
        if (constraintViolations == null) {
            return List.of();
        }
        return constraintViolations.stream().map(this::toViolation).collect(Collectors.toList());
    }

    private Violation toViolation(ConstraintViolation<?> constraintViolation) {
        return this.matchEndpointMethodParameter(constraintViolation).map(param -> this.createViolation(constraintViolation, (Parameter)param)).orElseGet(() -> Violation.In.unknown.field(this.dropMethodName(constraintViolation.getPropertyPath())).message(constraintViolation.getMessage()));
    }

    private Optional<Parameter> matchEndpointMethodParameter(ConstraintViolation<?> violation) {
        Iterator propertyPathIterator = violation.getPropertyPath().iterator();
        if (!propertyPathIterator.hasNext()) {
            return Optional.empty();
        }
        propertyPathIterator.next();
        if (!propertyPathIterator.hasNext()) {
            return Optional.empty();
        }
        String paramName = ((Path.Node)propertyPathIterator.next()).getName();
        Method method = this.resourceInfo.getResourceMethod();
        return Stream.of(method.getParameters()).filter(param -> param.getName().equals(paramName)).findFirst();
    }

    private Violation createViolation(ConstraintViolation<?> constraintViolation, Parameter param) {
        String message = constraintViolation.getMessage();
        if (param.getAnnotation(QueryParam.class) != null) {
            String field = param.getAnnotation(QueryParam.class).value();
            return Violation.In.query.field(field).message(message);
        }
        if (param.getAnnotation(PathParam.class) != null) {
            String field = param.getAnnotation(PathParam.class).value();
            return Violation.In.path.field(field).message(message);
        }
        if (param.getAnnotation(HeaderParam.class) != null) {
            String field = param.getAnnotation(HeaderParam.class).value();
            return Violation.In.header.field(field).message(message);
        }
        if (param.getAnnotation(FormParam.class) != null) {
            String field = param.getAnnotation(FormParam.class).value();
            return Violation.In.form.field(field).message(message);
        }
        String field = this.dropMethodNameAndArgumentPositionFromPath(constraintViolation.getPropertyPath());
        return Violation.In.body.field(field).message(message);
    }

    private String dropMethodNameAndArgumentPositionFromPath(Path propertyPath) {
        return this.serializePath(propertyPath, 2);
    }

    private String dropMethodName(Path propertyPath) {
        return this.serializePath(propertyPath, 1);
    }

    private String serializePath(Path propertyPath, int skipFirstSegments) {
        Iterator segmentIterator = propertyPath.iterator();
        ArrayList<String> pathSegments = new ArrayList<String>();
        while (segmentIterator.hasNext()) {
            if (skipFirstSegments > 0) {
                --skipFirstSegments;
                segmentIterator.next();
                continue;
            }
            pathSegments.add(((Path.Node)segmentIterator.next()).toString());
        }
        return String.join((CharSequence)".", pathSegments);
    }
}

