/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.Batch;
import com.tigerbeetle.UInt128;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public final class AccountBalanceBatch
extends Batch {
    static final AccountBalanceBatch EMPTY = new AccountBalanceBatch(0);

    public AccountBalanceBatch(int capacity) {
        super(capacity, 128);
    }

    AccountBalanceBatch(ByteBuffer buffer) {
        super(buffer, 128);
    }

    public BigInteger getDebitsPending() {
        int index = this.at(0);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getDebitsPending(UInt128 part) {
        return this.getUInt128(this.at(0), part);
    }

    void setDebitsPending(BigInteger debitsPending) {
        this.putUInt128(this.at(0), UInt128.asBytes(debitsPending));
    }

    void setDebitsPending(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(0), leastSignificant, mostSignificant);
    }

    void setDebitsPending(long leastSignificant) {
        this.putUInt128(this.at(0), leastSignificant, 0L);
    }

    public BigInteger getDebitsPosted() {
        int index = this.at(16);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getDebitsPosted(UInt128 part) {
        return this.getUInt128(this.at(16), part);
    }

    void setDebitsPosted(BigInteger debitsPosted) {
        this.putUInt128(this.at(16), UInt128.asBytes(debitsPosted));
    }

    void setDebitsPosted(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(16), leastSignificant, mostSignificant);
    }

    void setDebitsPosted(long leastSignificant) {
        this.putUInt128(this.at(16), leastSignificant, 0L);
    }

    public BigInteger getCreditsPending() {
        int index = this.at(32);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getCreditsPending(UInt128 part) {
        return this.getUInt128(this.at(32), part);
    }

    void setCreditsPending(BigInteger creditsPending) {
        this.putUInt128(this.at(32), UInt128.asBytes(creditsPending));
    }

    void setCreditsPending(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(32), leastSignificant, mostSignificant);
    }

    void setCreditsPending(long leastSignificant) {
        this.putUInt128(this.at(32), leastSignificant, 0L);
    }

    public BigInteger getCreditsPosted() {
        int index = this.at(48);
        return UInt128.asBigInteger(this.getUInt128(index, UInt128.LeastSignificant), this.getUInt128(index, UInt128.MostSignificant));
    }

    public long getCreditsPosted(UInt128 part) {
        return this.getUInt128(this.at(48), part);
    }

    void setCreditsPosted(BigInteger creditsPosted) {
        this.putUInt128(this.at(48), UInt128.asBytes(creditsPosted));
    }

    void setCreditsPosted(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(48), leastSignificant, mostSignificant);
    }

    void setCreditsPosted(long leastSignificant) {
        this.putUInt128(this.at(48), leastSignificant, 0L);
    }

    public long getTimestamp() {
        long value = this.getUInt64(this.at(64));
        return value;
    }

    void setTimestamp(long timestamp) {
        this.putUInt64(this.at(64), timestamp);
    }

    byte[] getReserved() {
        return this.getArray(this.at(72), 56);
    }

    void setReserved(byte[] reserved) {
        if (reserved == null) {
            reserved = new byte[56];
        }
        if (reserved.length != 56) {
            throw new IllegalArgumentException("Reserved must be 56 bytes long");
        }
        this.putArray(this.at(72), reserved);
    }

    static interface Struct {
        public static final int SIZE = 128;
        public static final int DebitsPending = 0;
        public static final int DebitsPosted = 16;
        public static final int CreditsPending = 32;
        public static final int CreditsPosted = 48;
        public static final int Timestamp = 64;
        public static final int Reserved = 72;
    }
}

