/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.Batch;
import com.tigerbeetle.UInt128;
import java.nio.ByteBuffer;

final class AccountFilterBatch
extends Batch {
    static final AccountFilterBatch EMPTY = new AccountFilterBatch(0);

    public AccountFilterBatch(int capacity) {
        super(capacity, 64);
    }

    AccountFilterBatch(ByteBuffer buffer) {
        super(buffer, 64);
    }

    public byte[] getAccountId() {
        return this.getUInt128(this.at(0));
    }

    public long getAccountId(UInt128 part) {
        return this.getUInt128(this.at(0), part);
    }

    public void setAccountId(byte[] accountId) {
        this.putUInt128(this.at(0), accountId);
    }

    public void setAccountId(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(0), leastSignificant, mostSignificant);
    }

    public void setAccountId(long leastSignificant) {
        this.putUInt128(this.at(0), leastSignificant, 0L);
    }

    public long getTimestampMin() {
        long value = this.getUInt64(this.at(16));
        return value;
    }

    public void setTimestampMin(long timestampMin) {
        this.putUInt64(this.at(16), timestampMin);
    }

    public long getTimestampMax() {
        long value = this.getUInt64(this.at(24));
        return value;
    }

    public void setTimestampMax(long timestampMax) {
        this.putUInt64(this.at(24), timestampMax);
    }

    public int getLimit() {
        int value = this.getUInt32(this.at(32));
        return value;
    }

    public void setLimit(int limit) {
        this.putUInt32(this.at(32), limit);
    }

    public int getFlags() {
        int value = this.getUInt32(this.at(36));
        return value;
    }

    public void setFlags(int flags) {
        this.putUInt32(this.at(36), flags);
    }

    byte[] getReserved() {
        return this.getArray(this.at(40), 24);
    }

    void setReserved(byte[] reserved) {
        if (reserved == null) {
            reserved = new byte[24];
        }
        if (reserved.length != 24) {
            throw new IllegalArgumentException("Reserved must be 24 bytes long");
        }
        this.putArray(this.at(40), reserved);
    }

    static interface Struct {
        public static final int SIZE = 64;
        public static final int AccountId = 0;
        public static final int TimestampMin = 16;
        public static final int TimestampMax = 24;
        public static final int Limit = 32;
        public static final int Flags = 36;
        public static final int Reserved = 40;
    }
}

