/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.AccountBalanceBatch;
import com.tigerbeetle.AccountBatch;
import com.tigerbeetle.AccountFilter;
import com.tigerbeetle.AssertionError;
import com.tigerbeetle.Batch;
import com.tigerbeetle.CreateAccountResultBatch;
import com.tigerbeetle.CreateTransferResultBatch;
import com.tigerbeetle.IdBatch;
import com.tigerbeetle.NativeClient;
import com.tigerbeetle.Request;
import com.tigerbeetle.TransferBatch;
import java.util.concurrent.CompletableFuture;

final class AsyncRequest<TResponse extends Batch>
extends Request<TResponse> {
    private final CompletableFuture<TResponse> future = new CompletableFuture();

    AsyncRequest(NativeClient nativeClient, Request.Operations operation, Batch batch) {
        super(nativeClient, operation, batch);
    }

    public static AsyncRequest<CreateAccountResultBatch> createAccounts(NativeClient nativeClient, AccountBatch batch) {
        return new AsyncRequest<CreateAccountResultBatch>(nativeClient, Request.Operations.CREATE_ACCOUNTS, batch);
    }

    public static AsyncRequest<AccountBatch> lookupAccounts(NativeClient nativeClient, IdBatch batch) {
        return new AsyncRequest<AccountBatch>(nativeClient, Request.Operations.LOOKUP_ACCOUNTS, batch);
    }

    public static AsyncRequest<CreateTransferResultBatch> createTransfers(NativeClient nativeClient, TransferBatch batch) {
        return new AsyncRequest<CreateTransferResultBatch>(nativeClient, Request.Operations.CREATE_TRANSFERS, batch);
    }

    public static AsyncRequest<TransferBatch> lookupTransfers(NativeClient nativeClient, IdBatch batch) {
        return new AsyncRequest<TransferBatch>(nativeClient, Request.Operations.LOOKUP_TRANSFERS, batch);
    }

    public static AsyncRequest<TransferBatch> getAccountTransfers(NativeClient nativeClient, AccountFilter filter) {
        return new AsyncRequest<TransferBatch>(nativeClient, Request.Operations.GET_ACCOUNT_TRANSFERS, filter.batch);
    }

    public static AsyncRequest<AccountBalanceBatch> getAccountBalances(NativeClient nativeClient, AccountFilter filter) {
        return new AsyncRequest<AccountBalanceBatch>(nativeClient, Request.Operations.GET_ACCOUNT_BALANCES, filter.batch);
    }

    public static AsyncRequest<AccountBatch> echo(NativeClient nativeClient, AccountBatch batch) {
        return new AsyncRequest<AccountBatch>(nativeClient, Request.Operations.ECHO_ACCOUNTS, batch);
    }

    public static AsyncRequest<TransferBatch> echo(NativeClient nativeClient, TransferBatch batch) {
        return new AsyncRequest<TransferBatch>(nativeClient, Request.Operations.ECHO_TRANSFERS, batch);
    }

    public CompletableFuture<TResponse> getFuture() {
        return this.future;
    }

    @Override
    protected void setResult(TResponse result) {
        boolean completed = this.future.complete(result);
        AssertionError.assertTrue(completed, "CompletableFuture already completed", new Object[0]);
    }

    @Override
    protected void setException(Throwable exception) {
        boolean completed = this.future.completeExceptionally(exception);
        AssertionError.assertTrue(completed, "CompletableFuture already completed", new Object[0]);
    }
}

