/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.Batch;
import com.tigerbeetle.UInt128;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class IdBatch
extends Batch {
    static final IdBatch EMPTY = new IdBatch(0);

    public IdBatch(int capacity) {
        super(capacity, 16);
    }

    IdBatch(ByteBuffer buffer) {
        super(buffer, 16);
    }

    public IdBatch(byte[] ... ids) {
        super(ids.length, 16);
        for (byte[] id : ids) {
            this.add(id);
        }
    }

    public void add(byte[] id) {
        super.add();
        this.setId(id);
    }

    public void add(long leastSignificant, long mostSignificant) {
        super.add();
        this.setId(leastSignificant, mostSignificant);
    }

    public void add(long leastSignificant) {
        super.add();
        this.setId(leastSignificant, 0L);
    }

    public byte[] getId() {
        return this.getUInt128(this.at(0));
    }

    public long getId(UInt128 part) {
        return this.getUInt128(this.at(0), part);
    }

    public void setId(byte[] id) {
        Objects.requireNonNull(id, "Id cannot be null");
        this.putUInt128(this.at(0), id);
    }

    public void setId(long leastSignificant, long mostSignificant) {
        this.putUInt128(this.at(0), leastSignificant, mostSignificant);
    }

    static interface Struct {
        public static final int SIZE = 16;
    }
}

