/*
 * Decompiled with CFR 0.152.
 */
package com.tigerbeetle;

import com.tigerbeetle.InitializationStatus;

public final class InitializationException
extends RuntimeException {
    private final int status;

    public InitializationException(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.status == InitializationStatus.Unexpected.value) {
            return "Unexpected internal error";
        }
        if (this.status == InitializationStatus.OutOfMemory.value) {
            return "Internal client ran out of memory";
        }
        if (this.status == InitializationStatus.AddressInvalid.value) {
            return "Replica addresses format is invalid";
        }
        if (this.status == InitializationStatus.AddressLimitExceeded.value) {
            return "Replica addresses limit exceeded";
        }
        if (this.status == InitializationStatus.ConcurrencyMaxInvalid.value) {
            return "Invalid concurrencyMax";
        }
        if (this.status == InitializationStatus.SystemResources.value) {
            return "Internal client ran out of system resources";
        }
        if (this.status == InitializationStatus.NetworkSubsystem.value) {
            return "Internal client had unexpected networking issues";
        }
        return "Error status " + this.status;
    }
}

