/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark;

import com.tigergraph.spark.client.Auth;
import com.tigergraph.spark.client.Builder;
import com.tigergraph.spark.client.Misc;
import com.tigergraph.spark.client.Write;
import com.tigergraph.spark.client.common.RestppResponse;
import com.tigergraph.spark.util.Options;
import com.tigergraph.spark.util.Utils;
import feign.FeignException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGraphConnection
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(TigerGraphConnection.class);
    private Options opts;
    private final String graph;
    private final String url;
    private final long creationTime;
    private String version;
    private transient Misc misc;
    private String basicAuth;
    private String secret;
    private String token;
    private boolean restAuthEnabled;
    private boolean restAuthInited;
    private transient Auth auth;
    static final String JOB_IDENTIFIER = "spark";
    static final String JOB_MACHINE = "all";
    private String loadingJobId = null;
    private transient Write write;

    public TigerGraphConnection(Options opts, long creationTime) {
        this.opts = opts;
        this.creationTime = creationTime;
        this.graph = opts.getString("graph");
        this.url = opts.getString("url");
        this.initAuth();
        this.version = opts.getString("version");
        if (Utils.isEmpty(this.version)) {
            RestppResponse verResp = this.getMisc().version();
            verResp.panicOnFail();
            this.version = Utils.extractVersion(verResp.message);
        }
        if (Utils.versionCmp(this.version, "3.6.0") <= 0) {
            throw new UnsupportedOperationException("TigerGraph version under 3.6.0 is unsupported, current version: " + this.version);
        }
        logger.info("TigerGraph version: {}", (Object)this.version);
        if (Options.OptionType.WRITE.equals((Object)opts.getOptionType()) && Utils.versionCmp(this.version, "3.9.4") >= 0) {
            this.loadingJobId = TigerGraphConnection.generateJobId(this.graph, opts.getString("loading.job"), creationTime);
        }
    }

    public TigerGraphConnection(Options opts) {
        this(opts, Instant.now().toEpochMilli());
    }

    private void initAuth() {
        if (!this.restAuthInited) {
            this.secret = this.opts.getString("secret");
            this.token = this.opts.getString("token");
            if (!Utils.isEmpty(this.opts.getString("username")) && !Utils.isEmpty(this.opts.getString("password"))) {
                this.basicAuth = new String(Base64.getEncoder().encode((this.opts.getString("username") + ":" + this.opts.getString("password")).getBytes()));
            }
            this.getAuth();
            this.restAuthEnabled = true;
            try {
                this.auth.checkAuthEnabled();
            }
            catch (FeignException e) {
                if (e.status() == 404) {
                    this.restAuthEnabled = false;
                    logger.warn("RESTPP authentication is not enabled, you can enable it via `gadmin config set RESTPP.Factory.EnableAuth true`");
                }
                throw e;
            }
            if (this.restAuthEnabled && Utils.isEmpty(this.token)) {
                Auth.AuthResponse resp;
                if (!Utils.isEmpty(this.basicAuth)) {
                    resp = this.auth.requestTokenWithUserPass(this.graph, this.basicAuth, 21600L);
                    resp.panicOnFail();
                    this.token = resp.results.get("token").asText();
                } else if (!Utils.isEmpty(this.secret)) {
                    resp = this.auth.requestTokenWithSecret(this.secret, 21600L);
                    resp.panicOnFail();
                    this.token = resp.token;
                } else {
                    throw new IllegalArgumentException("Restpp authentication is enabled, please provide at least one of the 'token', 'secret' or 'username/password' pair.");
                }
                logger.info("Requested new token {} for RESTPP authentication, expiration: {}", (Object)Utils.maskString(this.token, 2), (Object)resp.expiration);
            }
            this.restAuthInited = true;
        }
    }

    private Auth getAuth() {
        if (this.auth == null) {
            Builder builder = new Builder().setRequestOptions(this.opts.getInt("io.connect.timeout.ms"), this.opts.getInt("io.read.timeout.ms")).setRetryerWithoutAuth(this.opts.getInt("io.retry.interval.ms"), this.opts.getInt("io.max.retry.interval.ms"), this.opts.getInt("io.max.retry.attempts"), this.opts.getInt("io.retry.interval.ms"), this.opts.getInt("io.max.retry.interval.ms"), this.opts.getInt("io.max.retry.attempts"));
            if (this.url.trim().toLowerCase().startsWith("https://")) {
                builder.setSSL(this.opts.getString("ssl.mode"), this.opts.getString("ssl.truststore"), this.opts.getString("ssl.truststore.type"), this.opts.getString("ssl.truststore.password"));
            }
            this.auth = builder.build(Auth.class, this.url);
        }
        return this.auth;
    }

    public Misc getMisc() {
        if (!this.restAuthInited) {
            this.initAuth();
        }
        if (this.misc == null) {
            Builder builder = new Builder().setRequestOptions(this.opts.getInt("io.connect.timeout.ms"), this.opts.getInt("io.read.timeout.ms")).setRetryer(this.getAuth(), this.basicAuth, this.secret, this.token, this.opts.getInt("io.retry.interval.ms"), this.opts.getInt("io.max.retry.interval.ms"), this.opts.getInt("io.max.retry.attempts"), this.opts.getInt("io.retry.interval.ms"), this.opts.getInt("io.max.retry.interval.ms"), this.opts.getInt("io.max.retry.attempts")).setRequestInterceptor(this.basicAuth, this.token, this.restAuthEnabled);
            if (this.url.trim().toLowerCase().startsWith("https://")) {
                builder.setSSL(this.opts.getString("ssl.mode"), this.opts.getString("ssl.truststore"), this.opts.getString("ssl.truststore.type"), this.opts.getString("ssl.truststore.password"));
            }
            this.misc = builder.build(Misc.class, this.url);
        }
        return this.misc;
    }

    public Write getWrite() {
        if (!Options.OptionType.WRITE.equals((Object)this.opts.getOptionType())) {
            throw new UnsupportedOperationException("Can't build write client for OptionType " + (Object)((Object)this.opts.getOptionType()));
        }
        if (!this.restAuthInited) {
            this.initAuth();
        }
        if (this.write == null) {
            Builder builder = new Builder().setRequestOptions(this.opts.getInt("io.connect.timeout.ms"), this.opts.getInt("io.read.timeout.ms")).setRetryer(this.getAuth(), this.basicAuth, this.secret, this.token, this.opts.getInt("io.retry.interval.ms"), this.opts.getInt("io.max.retry.interval.ms"), this.opts.getInt("io.max.retry.attempts"), this.opts.getInt("loading.retry.interval.ms"), this.opts.getInt("loading.max.retry.interval.ms"), this.opts.getInt("loading.max.retry.attempts")).setRequestInterceptor(this.basicAuth, this.token, this.restAuthEnabled);
            if (this.url.trim().toLowerCase().startsWith("https://")) {
                builder.setSSL(this.opts.getString("ssl.mode"), this.opts.getString("ssl.truststore"), this.opts.getString("ssl.truststore.type"), this.opts.getString("ssl.truststore.password"));
            }
            this.write = builder.build(Write.class, this.url);
        }
        return this.write;
    }

    protected static String generateJobId(String graph, String jobname, long creationTime) {
        return graph + "." + jobname + "." + JOB_IDENTIFIER + "." + JOB_MACHINE + "." + creationTime;
    }

    public Options getOpts() {
        return this.opts;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLoadingJobId() {
        return this.loadingJobId;
    }

    public String getGraph() {
        return this.graph;
    }
}

