/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark;

import com.tigergraph.spark.read.TigerGraphScanBuilder;
import com.tigergraph.spark.write.TigerGraphWriteBuilder;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class TigerGraphTable
implements SupportsWrite,
SupportsRead {
    private static final String TABLE_NAME = "TigerGraphTable";
    private final StructType schema;
    private final long creationTime = Instant.now().toEpochMilli();

    TigerGraphTable(StructType schema) {
        this.schema = schema;
    }

    public String name() {
        return TABLE_NAME;
    }

    public StructType schema() {
        return this.schema;
    }

    public Set<TableCapability> capabilities() {
        return new HashSet<TableCapability>(2){
            {
                this.add(TableCapability.BATCH_WRITE);
                this.add(TableCapability.STREAMING_WRITE);
            }
        };
    }

    public TigerGraphWriteBuilder newWriteBuilder(LogicalWriteInfo info) throws RuntimeException {
        return new TigerGraphWriteBuilder(info, this.creationTime);
    }

    public TigerGraphScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new TigerGraphScanBuilder();
    }
}

