/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.client;

import com.tigergraph.spark.client.Auth;
import com.tigergraph.spark.client.common.RestppAuthInterceptor;
import com.tigergraph.spark.client.common.RestppDecoder;
import com.tigergraph.spark.client.common.RestppEncoder;
import com.tigergraph.spark.client.common.RestppErrorDecoder;
import com.tigergraph.spark.client.common.RestppRetryer;
import com.tigergraph.spark.util.Utils;
import feign.Client;
import feign.Feign;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.hc5.ApacheHttp5Client;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.spark.SparkFiles;

public class Builder {
    private Feign.Builder builder = new Feign.Builder();
    private HttpClientBuilder hc5builder = HttpClientBuilder.create();
    private PoolingHttpClientConnectionManagerBuilder connMgrBuilder = PoolingHttpClientConnectionManagerBuilder.create();
    private Encoder encoder = RestppEncoder.INSTANCE;
    private Decoder decoder = RestppDecoder.INSTANCE;
    private ErrorDecoder errDecoder = new RestppErrorDecoder(RestppDecoder.INSTANCE);
    private Retryer retryer = new Retryer.Default();
    private RequestInterceptor reqInterceptor;
    private Request.Options reqOpts = new Request.Options();

    public Builder setRequestOptions(int connectTimeoutMs, int readTimeoutMs) {
        this.reqOpts = new Request.Options((long)connectTimeoutMs, TimeUnit.MILLISECONDS, (long)readTimeoutMs, TimeUnit.MILLISECONDS, false);
        return this;
    }

    public Builder setRetryableCode(Integer ... code) {
        this.errDecoder = new RestppErrorDecoder(this.decoder, code);
        return this;
    }

    public Builder setRetryer(Auth auth, String basicAuth, String secret, String token, int ioPeriod, int ioMaxPeriod, int ioMaxAttempts, int serverPeriod, int serverMaxPeriod, int serverMaxAttempts) {
        this.retryer = new RestppRetryer(auth, basicAuth, secret, token, ioPeriod, ioMaxPeriod, ioMaxAttempts, serverPeriod, serverMaxPeriod, serverMaxAttempts);
        return this;
    }

    public Builder setRetryerWithoutAuth(int ioPeriod, int ioMaxPeriod, int ioMaxAttempts, int serverPeriod, int serverMaxPeriod, int serverMaxAttempts) {
        this.retryer = new RestppRetryer(ioPeriod, ioMaxPeriod, ioMaxAttempts, serverPeriod, serverMaxPeriod, serverMaxAttempts);
        return this;
    }

    public Builder setRequestInterceptor(String basicAuth, String token, boolean restAuthEnabled) {
        this.reqInterceptor = new RestppAuthInterceptor(basicAuth, token, restAuthEnabled);
        return this;
    }

    public Builder setSSL(String mode, String trustStoreFile, String trustStoreType, String password) {
        NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        try {
            switch (mode) {
                case "basic": {
                    sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy());
                    break;
                }
                case "verifyHostname": {
                    hostnameVerifier = new DefaultHostnameVerifier();
                }
                case "verifyCA": {
                    if (Utils.isEmpty(trustStoreFile)) {
                        throw new IllegalArgumentException("\"ssl.truststore\" is required for mode " + mode);
                    }
                    String path = SparkFiles.get((String)trustStoreFile);
                    FileInputStream in = new FileInputStream(new File(path));
                    KeyStore truststore = KeyStore.getInstance(trustStoreType);
                    if (Utils.isEmpty(password)) {
                        truststore.load(in, new char[0]);
                    } else {
                        truststore.load(in, password.toCharArray());
                    }
                    sslContextBuilder.loadTrustMaterial(truststore, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid SSL mode: " + mode);
                }
            }
            this.connMgrBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)hostnameVerifier));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to configure SSL", e);
        }
        return this;
    }

    public <T> T build(Class<T> apiType, String url) {
        this.builder.encoder(this.encoder).decoder(this.decoder).errorDecoder(this.errDecoder).retryer(this.retryer).options(this.reqOpts).client((Client)new ApacheHttp5Client((HttpClient)this.hc5builder.setConnectionManager((HttpClientConnectionManager)this.connMgrBuilder.build()).build()));
        if (this.reqInterceptor != null) {
            this.builder.requestInterceptor(this.reqInterceptor);
        }
        return (T)this.builder.target(new LoadBalanceTarget<T>(apiType, url));
    }

    public static class LoadBalanceTarget<T>
    extends Target.HardCodedTarget<T> {
        private final List<String> urls;
        private final Random rand = new Random();

        public LoadBalanceTarget(Class<T> type, String url) {
            super(type, url);
            this.urls = Arrays.stream(url.split(",")).map(String::trim).filter(s -> !s.isEmpty()).distinct().collect(Collectors.toList());
        }

        public String url() {
            return this.urls.get(this.rand.nextInt(this.urls.size()));
        }

        public Request apply(RequestTemplate input) {
            input.target(this.url());
            return input.request();
        }
    }
}

