/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.client.common;

import com.tigergraph.spark.util.Utils;
import feign.RequestInterceptor;
import feign.RequestTemplate;

public class RestppAuthInterceptor
implements RequestInterceptor {
    static final String GSQL_ENDPOINT = "/gsqlserver";
    private final String basicAuth;
    private final String token;
    private final boolean restAuthEnabled;

    public RestppAuthInterceptor(String basicAuth, String token, boolean restAuthEnabled) {
        this.basicAuth = basicAuth;
        this.token = token;
        this.restAuthEnabled = restAuthEnabled;
    }

    public void apply(RequestTemplate template) {
        if (this.restAuthEnabled) {
            template.header("Authorization", new String[]{"Bearer " + this.token});
        } else if (template.path().contains(GSQL_ENDPOINT)) {
            if (!Utils.isEmpty(this.token)) {
                template.header("Authorization", new String[]{"Bearer " + this.token});
            } else if (!Utils.isEmpty(this.basicAuth)) {
                template.header("Authorization", new String[]{"Basic " + this.basicAuth});
            } else {
                throw new IllegalArgumentException("Failed to send request to " + template.path() + ", no username/password or token provided.");
            }
        }
    }
}

