/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.client.common;

import com.tigergraph.spark.client.common.RestppResponse;
import feign.FeignException;
import feign.Response;
import feign.RetryableException;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestppErrorDecoder
implements ErrorDecoder {
    private static final Logger logger = LoggerFactory.getLogger(RestppErrorDecoder.class);
    static final List<Integer> DEFAULT_RETRYABLE_CODE = Arrays.asList(408, 502, 503, 504);
    final List<Integer> retryableCode;
    final Decoder decoder;
    final ErrorDecoder errDecoder = new ErrorDecoder.Default();

    public RestppErrorDecoder(Decoder decoder) {
        this.decoder = decoder;
        this.retryableCode = DEFAULT_RETRYABLE_CODE;
    }

    public RestppErrorDecoder(Decoder decoder, Integer ... retryableCode) {
        this.decoder = decoder;
        this.retryableCode = Arrays.asList(retryableCode);
    }

    public Exception decode(String methodKey, Response response) {
        Exception e = this.errDecoder.decode(methodKey, response);
        if (!(e instanceof RetryableException)) {
            boolean shouldRetry = false;
            if (response.status() == 403) {
                try {
                    byte[] body = ((ByteBuffer)((FeignException)((Object)e)).responseBody().get()).array();
                    RestppResponse resp = (RestppResponse)this.decoder.decode(response.toBuilder().body(body).build(), RestppResponse.class);
                    if ("REST-10019".equals(resp.code)) {
                        logger.info("{} token expiration, attempt to refresh and retry.", (Object)resp.code);
                        shouldRetry = true;
                    }
                }
                catch (Exception exception) {}
            } else if (this.retryableCode.contains(response.status())) {
                shouldRetry = true;
            }
            if (shouldRetry) {
                return new RetryableException(response.status(), e.getMessage(), response.request().httpMethod(), (Throwable)e, null, response.request());
            }
        }
        return e;
    }
}

