/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.client.common;

import com.tigergraph.spark.client.Auth;
import com.tigergraph.spark.util.Utils;
import feign.RetryableException;
import feign.Retryer;
import java.io.IOException;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestppRetryer
implements Retryer {
    private static final Logger logger = LoggerFactory.getLogger(RestppRetryer.class);
    private static final Random rand = new Random();
    private static int TYPE_AUTH = 0;
    private static int TYPE_IO = 1;
    private static int TYPE_SERVER = 2;
    private static final int REFRESH_MAX_ATTEMPTS = 1;
    private static final int REFRESH_PERIOD_MS = 3000;
    private final Auth auth;
    private final String basicAuth;
    private final String secret;
    private final String token;
    private final int[] period = new int[3];
    private final int[] maxPeriod = new int[3];
    private final int[] maxAttempts = new int[3];
    private final int[] attempts = new int[3];
    private final int[] sleptForMillis = new int[3];

    public RestppRetryer(Auth auth, String basicAuth, String secret, String token, int ioPeriod, int ioMaxPeriod, int ioMaxAttempts, int serverPeriod, int serverMaxPeriod, int serverMaxAttempts) {
        this.auth = auth;
        this.basicAuth = basicAuth;
        this.secret = secret;
        this.token = token;
        this.period[RestppRetryer.TYPE_AUTH] = 3000;
        this.maxPeriod[RestppRetryer.TYPE_AUTH] = 3000;
        this.maxAttempts[RestppRetryer.TYPE_AUTH] = 1;
        this.period[RestppRetryer.TYPE_IO] = ioPeriod;
        this.maxPeriod[RestppRetryer.TYPE_IO] = ioMaxPeriod;
        this.maxAttempts[RestppRetryer.TYPE_IO] = ioMaxAttempts;
        this.period[RestppRetryer.TYPE_SERVER] = serverPeriod;
        this.maxPeriod[RestppRetryer.TYPE_SERVER] = serverMaxPeriod;
        this.maxAttempts[RestppRetryer.TYPE_SERVER] = serverMaxAttempts;
    }

    public RestppRetryer(int ioPeriod, int ioMaxPeriod, int ioMaxAttempts, int serverPeriod, int serverMaxPeriod, int serverMaxAttempts) {
        this(null, null, null, null, ioPeriod, ioMaxPeriod, ioMaxAttempts, serverPeriod, serverMaxPeriod, serverMaxAttempts);
    }

    public void continueOrPropagate(RetryableException e) {
        long interval;
        String reason;
        int retryType;
        if (e.getCause() instanceof IOException) {
            retryType = TYPE_IO;
            reason = e.getCause().toString();
        } else if (e.status() == 403) {
            retryType = TYPE_AUTH;
            reason = String.format("Token %s expired, attempt to retry after refresh", Utils.maskString(this.token, 2));
        } else {
            retryType = TYPE_SERVER;
            reason = String.valueOf(e.status());
        }
        int n = retryType;
        int n2 = this.attempts[n];
        this.attempts[n] = n2 + 1;
        if (n2 >= this.maxAttempts[retryType]) {
            throw e;
        }
        if (e.retryAfter() != null) {
            interval = e.retryAfter().getTime() - this.currentTimeMillis();
            if (interval > (long)this.maxPeriod[retryType]) {
                interval = this.maxPeriod[retryType];
            }
            if (interval < 0L) {
                return;
            }
        } else {
            interval = RestppRetryer.jitter(this.nextMaxInterval(retryType));
            logger.info("{}, retry in {} ms, attempt {}", new Object[]{reason, interval, this.attempts[retryType]});
        }
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            throw e;
        }
        int n3 = retryType;
        this.sleptForMillis[n3] = (int)((long)this.sleptForMillis[n3] + interval);
        if (retryType == TYPE_AUTH && this.auth != null) {
            if (!Utils.isEmpty(this.basicAuth)) {
                this.auth.refreshTokenWithUserPass(this.token, this.basicAuth, 21600L).panicOnFail();
            } else if (!Utils.isEmpty(this.secret)) {
                this.auth.refreshTokenWithSecrect(this.token, this.secret, 21600L).panicOnFail();
            } else {
                throw e;
            }
            logger.info("Successfully refreshed token {} for {} seconds", (Object)Utils.maskString(this.token, 2), (Object)21600L);
        }
    }

    public RestppRetryer clone() {
        return new RestppRetryer(this.auth, this.basicAuth, this.secret, this.token, this.period[TYPE_IO], this.maxPeriod[TYPE_IO], this.maxAttempts[TYPE_IO], this.period[TYPE_SERVER], this.maxPeriod[TYPE_SERVER], this.maxAttempts[TYPE_SERVER]);
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected static long jitter(long interval) {
        return (long)(0.75 * (double)interval + 0.5 * (double)interval * rand.nextDouble());
    }

    private long nextMaxInterval(int retryType) {
        long interval = (long)((double)this.period[retryType] * Math.pow(1.5, this.attempts[retryType] - 1));
        return interval > (long)this.maxPeriod[retryType] ? (long)this.maxPeriod[retryType] : interval;
    }
}

