/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.client.common;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.tigergraph.spark.client.common.RestppDecoder;
import com.tigergraph.spark.client.common.RestppStreamResponse;
import feign.FeignException;
import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public class RestppStreamDecoder
implements Decoder {
    private static final String KEY_CODE = "code";
    private static final String KEY_ERROR = "error";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_RESULTS = "results";

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        if (response.status() == 404 || response.status() == 204 || !type.equals(RestppStreamResponse.class)) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader(response.charset());
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 1);
        }
        try {
            reader.mark(1);
            if (reader.read() == -1) {
                return null;
            }
            reader.reset();
            return this.parse(reader);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw e;
        }
    }

    private RestppStreamResponse parse(Reader reader) throws IOException {
        JsonFactory factory = new JsonFactory();
        RestppStreamResponse resp = new RestppStreamResponse();
        JsonParser parser = factory.createParser(reader);
        parser.setCodec((ObjectCodec)RestppDecoder.MAPPER);
        if (!JsonToken.START_OBJECT.equals((Object)parser.nextToken())) {
            return null;
        }
        while (!JsonToken.END_OBJECT.equals((Object)parser.nextToken())) {
            if (JsonToken.FIELD_NAME.equals((Object)parser.currentToken())) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                if (KEY_CODE.equals(fieldName)) {
                    resp.code = parser.getValueAsString();
                } else if (KEY_ERROR.equals(fieldName)) {
                    resp.error = Boolean.parseBoolean(parser.getValueAsString());
                } else if (KEY_MESSAGE.equals(fieldName)) {
                    resp.message = parser.getValueAsString();
                } else if (KEY_RESULTS.equals(fieldName) && !resp.error && JsonToken.START_ARRAY.equals((Object)parser.currentToken())) {
                    resp.results = parser;
                    break;
                }
            }
            parser.skipChildren();
        }
        return resp;
    }
}

