/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class OptionDef
implements Serializable {
    public static final Serializable NO_DEFAULT_VALUE = UUID.randomUUID();
    private final Map<String, OptionKey> optionKeys = new HashMap<String, OptionKey>();

    public Map<String, OptionKey> optionKeys() {
        return this.optionKeys;
    }

    public OptionDef define(String name, Type type, Serializable defaultValue, boolean required, Validator validator, String group) {
        OptionKey key = new OptionKey(name, type, defaultValue, required, validator, group);
        this.optionKeys.put(name, key);
        return this;
    }

    public OptionDef define(String name, Type type, String group) {
        return this.define(name, type, false, group);
    }

    public OptionDef define(String name, Type type, boolean required, String group) {
        return this.define(name, type, NO_DEFAULT_VALUE, required, null, group);
    }

    public static class OptionKey
    implements Serializable {
        public final String name;
        public final Type type;
        public final Serializable defaultValue;
        public final boolean required;
        public final Validator validator;
        public final String group;

        public OptionKey(String name, Type type, Serializable defaultValue, boolean required, Validator validator, String group) {
            this.name = name;
            this.type = type;
            this.defaultValue = NO_DEFAULT_VALUE.equals(defaultValue) ? NO_DEFAULT_VALUE : defaultValue;
            this.required = required;
            this.validator = validator;
            this.group = group;
        }

        public boolean hasDefault() {
            return !NO_DEFAULT_VALUE.equals(this.defaultValue);
        }
    }

    public static enum Type {
        BOOLEAN,
        STRING,
        INT,
        SHORT,
        LONG,
        DOUBLE;

    }

    public static interface Validator
    extends Serializable {
        public void ensureValid(String var1, Serializable var2);
    }

    public static class ValidString
    implements Validator {
        final List<String> validStrings;

        private ValidString(List<String> validStrings) {
            this.validStrings = validStrings;
        }

        public static ValidString in(String ... validStrings) {
            return new ValidString(Arrays.asList(validStrings));
        }

        @Override
        public void ensureValid(String name, Serializable value) {
            if (this.validStrings.size() > 0 && !this.validStrings.contains(value)) {
                if (this.validStrings.size() == 1) {
                    throw new IllegalArgumentException("Option(" + name + ") must be: " + this.validStrings.get(0));
                }
                throw new IllegalArgumentException("Option(" + name + ") must be one of: " + String.join((CharSequence)", ", this.validStrings));
            }
        }
    }
}

