/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.util;

import com.tigergraph.spark.util.OptionDef;
import com.tigergraph.spark.util.OptionError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Options
implements Serializable {
    private final OptionType optionType;
    public static final String GRAPH = "graph";
    public static final String URL = "url";
    public static final String VERSION = "version";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SECRET = "secret";
    public static final String TOKEN = "token";
    public static final String LOADING_JOB = "loading.job";
    public static final String LOADING_FILENAME = "loading.filename";
    public static final String LOADING_SEPARATOR = "loading.separator";
    public static final String LOADING_EOL = "loading.eol";
    public static final String LOADING_BATCH_SIZE_BYTES = "loading.batch.size.bytes";
    public static final String LOADING_TIMEOUT_MS = "loading.timeout.ms";
    public static final String LOADING_MAX_PERCENT_ERROR = "loading.max.percent.error";
    public static final String LOADING_MAX_NUM_ERROR = "loading.max.num.error";
    public static final String LOADING_RETRY_INTERVAL_MS = "loading.retry.interval.ms";
    public static final String LOADING_MAX_RETRY_INTERVAL_MS = "loading.max.retry.interval.ms";
    public static final String LOADING_MAX_RETRY_ATTEMPTS = "loading.max.retry.attempts";
    public static final String LOADING_SEPARATOR_DEFAULT = ",";
    public static final String LOADING_EOL_DEFAULT = "\n";
    public static final int LOADING_BATCH_SIZE_BYTES_DEFAULT = 0x200000;
    public static final int LOADING_TIMEOUT_MS_DEFAULT = 0;
    public static final int LOADING_RETRY_INTERVAL_MS_DEFAULT = 5000;
    public static final int LOADING_MAX_RETRY_INTERVAL_MS_DEFAULT = 300000;
    public static final int LOADING_MAX_RETRY_ATTEMPTS_DEFAULT = 10;
    public static final String IO_CONNECT_TIMEOUT_MS = "io.connect.timeout.ms";
    public static final String IO_READ_TIMEOUT_MS = "io.read.timeout.ms";
    public static final String IO_RETRY_INTERVAL_MS = "io.retry.interval.ms";
    public static final String IO_MAX_RETRY_INTERVAL_MS = "io.max.retry.interval.ms";
    public static final String IO_MAX_RETRY_ATTEMPTS = "io.max.retry.attempts";
    public static final int IO_CONNECT_TIMEOUT_MS_DEFAULT = 30000;
    public static final int IO_READ_TIMEOUT_MS_DEFAULT = 60000;
    public static final int IO_RETRY_INTERVAL_MS_DEFAULT = 5000;
    public static final int IO_MAX_RETRY_INTERVAL_MS_DEFAULT = 10000;
    public static final int IO_MAX_RETRY_ATTEMPTS_DEFAULT = 5;
    public static final String SSL_MODE = "ssl.mode";
    public static final String SSL_MODE_BASIC = "basic";
    public static final String SSL_MODE_VERIFY_CA = "verifyCA";
    public static final String SSL_MODE_VERIFY_HOSTNAME = "verifyHostname";
    public static final String SSL_TRUSTSTORE = "ssl.truststore";
    public static final String SSL_TRUSTSTORE_TYPE = "ssl.truststore.type";
    public static final String SSL_TRUSTSTORE_PASSWORD = "ssl.truststore.password";
    public static final String SSL_TRUSTSTORE_TYPE_DEFAULT = "JKS";
    public static final String GROUP_GENERAL = "general";
    public static final String GROUP_AUTH = "auth";
    public static final String GROUP_LOADING_JOB = "loading.job";
    public static final String GROUP_TRANSPORT_TIMEOUT = "transport.timeout";
    public static final String GROUP_SSL = "ssl";
    private final Map<String, String> originals;
    private final Map<String, Serializable> transformed = new HashMap<String, Serializable>();
    private final OptionDef definition;

    public Options(Map<String, String> originals, OptionType ot) {
        this.optionType = ot;
        this.originals = originals != null ? originals : new HashMap();
        this.definition = new OptionDef().define(GRAPH, OptionDef.Type.STRING, true, GROUP_GENERAL).define(URL, OptionDef.Type.STRING, true, GROUP_GENERAL).define(VERSION, OptionDef.Type.STRING, GROUP_GENERAL).define(USERNAME, OptionDef.Type.STRING, GROUP_AUTH).define(PASSWORD, OptionDef.Type.STRING, GROUP_AUTH).define(SECRET, OptionDef.Type.STRING, GROUP_AUTH).define(TOKEN, OptionDef.Type.STRING, GROUP_AUTH).define(IO_READ_TIMEOUT_MS, OptionDef.Type.INT, Integer.valueOf(60000), true, null, GROUP_TRANSPORT_TIMEOUT).define(IO_CONNECT_TIMEOUT_MS, OptionDef.Type.INT, Integer.valueOf(30000), true, null, GROUP_TRANSPORT_TIMEOUT).define(IO_RETRY_INTERVAL_MS, OptionDef.Type.INT, Integer.valueOf(5000), true, null, GROUP_TRANSPORT_TIMEOUT).define(IO_MAX_RETRY_INTERVAL_MS, OptionDef.Type.INT, Integer.valueOf(10000), true, null, GROUP_TRANSPORT_TIMEOUT).define(IO_MAX_RETRY_ATTEMPTS, OptionDef.Type.INT, Integer.valueOf(5), true, null, GROUP_TRANSPORT_TIMEOUT).define(SSL_MODE, OptionDef.Type.STRING, (Serializable)((Object)SSL_MODE_BASIC), true, OptionDef.ValidString.in(SSL_MODE_BASIC, SSL_MODE_VERIFY_CA, SSL_MODE_VERIFY_HOSTNAME), GROUP_SSL).define(SSL_TRUSTSTORE, OptionDef.Type.STRING, null, false, null, GROUP_SSL).define(SSL_TRUSTSTORE_TYPE, OptionDef.Type.STRING, (Serializable)((Object)SSL_TRUSTSTORE_TYPE_DEFAULT), false, null, GROUP_SSL).define(SSL_TRUSTSTORE_PASSWORD, OptionDef.Type.STRING, null, false, null, GROUP_SSL);
        if (OptionType.WRITE.equals((Object)ot)) {
            this.definition.define("loading.job", OptionDef.Type.STRING, true, "loading.job").define(LOADING_FILENAME, OptionDef.Type.STRING, true, "loading.job").define(LOADING_SEPARATOR, OptionDef.Type.STRING, (Serializable)((Object)LOADING_SEPARATOR_DEFAULT), true, null, "loading.job").define(LOADING_EOL, OptionDef.Type.STRING, (Serializable)((Object)LOADING_EOL_DEFAULT), true, null, "loading.job").define(LOADING_BATCH_SIZE_BYTES, OptionDef.Type.INT, Integer.valueOf(0x200000), true, null, "loading.job").define(LOADING_TIMEOUT_MS, OptionDef.Type.INT, Integer.valueOf(0), true, null, "loading.job").define(LOADING_MAX_PERCENT_ERROR, OptionDef.Type.DOUBLE, "loading.job").define(LOADING_MAX_NUM_ERROR, OptionDef.Type.INT, "loading.job").define(LOADING_RETRY_INTERVAL_MS, OptionDef.Type.INT, Integer.valueOf(5000), true, null, "loading.job").define(LOADING_MAX_RETRY_INTERVAL_MS, OptionDef.Type.INT, Integer.valueOf(300000), true, null, "loading.job").define(LOADING_MAX_RETRY_ATTEMPTS, OptionDef.Type.INT, Integer.valueOf(10), true, null, "loading.job");
        }
    }

    protected List<OptionError> validateOpts() {
        ArrayList<OptionError> errors = new ArrayList<OptionError>();
        this.definition.optionKeys().forEach((k, v) -> {
            OptionError err = null;
            String key = v.name;
            Serializable value = null;
            try {
                value = this.parse(v.name);
                this.transformed.put(key, value);
            }
            catch (Exception e) {
                err = new OptionError(key, value, e.getMessage());
            }
            try {
                if (v.validator != null && this.containsOption(key)) {
                    v.validator.ensureValid(key, value);
                }
            }
            catch (Exception e) {
                if (err == null) {
                    err = new OptionError(key, value, e.getMessage());
                }
                err.getErrorMsgs().add(e.getMessage());
            }
            if (err != null) {
                errors.add(err);
            }
        });
        return errors;
    }

    public void validate() {
        List<OptionError> errors = this.validateOpts();
        if (errors != null && errors.size() > 0) {
            throw new IllegalArgumentException("Invalid input options: " + errors.stream().map(e -> e.toString()).reduce(". ", String::concat));
        }
    }

    public boolean containsOption(String key) {
        if (!this.originals.containsKey(key)) {
            if (this.definition.optionKeys().containsKey(key)) {
                OptionDef.OptionKey optionKey = this.definition.optionKeys().get(key);
                if (optionKey.required || optionKey.hasDefault()) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private Serializable parse(String key) {
        if (this.definition.optionKeys().containsKey(key)) {
            OptionDef.OptionKey optionKey = this.definition.optionKeys().get(key);
            if (this.originals.containsKey(key)) {
                String value = this.originals.get(key);
                String trimmed = null;
                if (value != null) {
                    trimmed = value.trim();
                }
                OptionDef.Type type = optionKey.type;
                try {
                    switch (type) {
                        case BOOLEAN: {
                            if (trimmed != null && trimmed.equalsIgnoreCase("true")) {
                                return Boolean.valueOf(true);
                            }
                            if (trimmed != null && trimmed.equalsIgnoreCase("false")) {
                                return Boolean.valueOf(false);
                            }
                            throw new IllegalArgumentException("Expected value to be either true or false");
                        }
                        case STRING: {
                            return value;
                        }
                        case INT: {
                            return Integer.valueOf(Integer.parseInt(trimmed));
                        }
                        case LONG: {
                            return Long.valueOf(Long.parseLong(trimmed));
                        }
                        case DOUBLE: {
                            return Double.valueOf(Double.parseDouble(trimmed));
                        }
                    }
                    throw new IllegalStateException("Unknown type.");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Option(" + key + ") failed to convert the value to type " + (Object)((Object)type) + ", error is " + e.toString());
                }
            }
            if (optionKey.hasDefault()) {
                return optionKey.defaultValue;
            }
            if (optionKey.required) {
                throw new IllegalArgumentException("Option(" + key + ") has no default value and has not been set to a value");
            }
            return null;
        }
        throw new IllegalArgumentException("Option(" + key + ") is not defined");
    }

    public Object get(String key) {
        if (this.transformed.containsKey(key)) {
            return this.transformed.get(key);
        }
        if (this.originals.containsKey(key)) {
            return this.originals.get(key);
        }
        return null;
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public Integer getInt(String key) {
        return (Integer)this.get(key);
    }

    public Long getLong(String key) {
        return (Long)this.get(key);
    }

    public Double getDouble(String key) {
        return (Double)this.get(key);
    }

    public Map<String, String> getOriginals() {
        return this.originals;
    }

    public OptionType getOptionType() {
        return this.optionType;
    }

    public static enum OptionType {
        WRITE,
        READ;

    }
}

