/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Utils {
    public static final String DEFAULT_VERSION = "999.999.999";
    public static final Pattern VERSION_PARTTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+)");

    public static String extractVersion(String input) {
        Matcher matcher = VERSION_PARTTERN.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return DEFAULT_VERSION;
    }

    public static int versionCmp(String v1, String v2) {
        return Utils.fmtVersion(v1).compareTo(Utils.fmtVersion(v2));
    }

    private static String fmtVersion(String version) {
        ArrayList<String> ver = new ArrayList<String>();
        String[] verSplit = version.split("\\.");
        for (int i = 0; i < 3; ++i) {
            if (i >= verSplit.length) {
                ver.add("0");
                continue;
            }
            ver.add(verSplit[i]);
        }
        return ver.stream().map(v -> String.format("%03d", Integer.valueOf(v))).collect(Collectors.joining());
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String maskString(String s, int keepHeadTail) {
        if (s == null) {
            return "";
        }
        if (2 * keepHeadTail >= s.length()) {
            return s;
        }
        return s.substring(0, keepHeadTail) + String.join((CharSequence)"", Collections.nCopies(s.length() - 2 * keepHeadTail, "*")) + s.substring(s.length() - keepHeadTail);
    }

    public static void removeUserData(JsonNode in) {
        List badDataV1 = in.findParents("invalidAttributeLinesData");
        badDataV1.forEach(json -> ((ObjectNode)json).remove("invalidAttributeLinesData"));
        List badDataV2 = in.findParents("lineData");
        badDataV2.forEach(json -> ((ObjectNode)json).remove("lineData"));
    }
}

