/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.write;

import com.tigergraph.spark.TigerGraphConnection;
import com.tigergraph.spark.client.common.RestppResponse;
import com.tigergraph.spark.util.Utils;
import com.tigergraph.spark.write.TigerGraphBatchWriterFactory;
import com.tigergraph.spark.write.TigerGraphWriteBase;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGraphBatchWrite
extends TigerGraphWriteBase
implements BatchWrite {
    private static final Logger logger = LoggerFactory.getLogger(TigerGraphBatchWrite.class);

    TigerGraphBatchWrite(StructType schema, TigerGraphConnection conn) {
        super(schema, conn);
    }

    public TigerGraphBatchWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
        return new TigerGraphBatchWriterFactory(this.schema, this.conn);
    }

    public void commit(WriterCommitMessage[] messages) {
        logger.info("Finished batch loading job {}", (Object)(this.conn.getLoadingJobId() == null ? "" : this.conn.getLoadingJobId()));
        logger.info("Total processed rows: {}", (Object)this.getTotalProcessedRows(messages));
        logger.info("Processed rows of each task:\n{}", (Object)this.getTaskSummury(messages));
        RestppResponse resp = this.getLoadingStatistics();
        if (resp != null) {
            Utils.removeUserData(resp.results);
            logger.info("Overall loading statistics: {}", (Object)resp.results.toPrettyString());
        }
    }

    public void abort(WriterCommitMessage[] messages) {
        logger.error("Aborted batch loading job {}", (Object)(this.conn.getLoadingJobId() == null ? "" : this.conn.getLoadingJobId()));
        logger.info("Total processed rows: {}", (Object)this.getTotalProcessedRows(messages));
        logger.info("Processed rows of each task:\n{}", (Object)this.getTaskSummury(messages));
        RestppResponse resp = this.getLoadingStatistics();
        if (resp != null) {
            Utils.removeUserData(resp.results);
            logger.info("Overall loading statistics: {}", (Object)resp.results.toPrettyString());
        }
    }
}

