/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.write;

import com.tigergraph.spark.TigerGraphConnection;
import com.tigergraph.spark.write.TigerGraphDataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGraphBatchWriterFactory
implements DataWriterFactory {
    private static final Logger logger = LoggerFactory.getLogger(TigerGraphBatchWriterFactory.class);
    private final StructType schema;
    private final TigerGraphConnection conn;

    TigerGraphBatchWriterFactory(StructType schema, TigerGraphConnection conn) {
        this.schema = schema;
        this.conn = conn;
        logger.info("Created {} for executor", TigerGraphBatchWriterFactory.class);
    }

    public TigerGraphDataWriter createWriter(int partitionId, long taskId) {
        logger.info("Creating TigerGraph batch writer for partitionId {}, taskId {}.", (Object)partitionId, (Object)taskId);
        return new TigerGraphDataWriter(this.schema, this.conn, partitionId, taskId);
    }
}

