/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.write;

import com.tigergraph.spark.TigerGraphConnection;
import com.tigergraph.spark.write.TigerGraphBatchWriterFactory;
import com.tigergraph.spark.write.TigerGraphDataWriter;
import org.apache.spark.sql.connector.write.streaming.StreamingDataWriterFactory;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGraphStreamWriterFactory
implements StreamingDataWriterFactory {
    private static final Logger logger = LoggerFactory.getLogger(TigerGraphStreamWriterFactory.class);
    private final StructType schema;
    private final TigerGraphConnection conn;

    TigerGraphStreamWriterFactory(StructType schema, TigerGraphConnection conn) {
        this.schema = schema;
        this.conn = conn;
        logger.info("Created {} for executor", TigerGraphBatchWriterFactory.class);
    }

    public TigerGraphDataWriter createWriter(int partitionId, long taskId, long epochId) {
        logger.info("Create TigerGraph streaming writer for partitionId {}, taskId {}, epochId {}.", new Object[]{partitionId, taskId, epochId});
        return new TigerGraphDataWriter(this.schema, this.conn, partitionId, taskId, epochId);
    }
}

