/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.write;

import com.tigergraph.spark.TigerGraphConnection;
import com.tigergraph.spark.client.common.RestppResponse;
import com.tigergraph.spark.util.Utils;
import com.tigergraph.spark.write.TigerGraphStreamWriterFactory;
import com.tigergraph.spark.write.TigerGraphWriteBase;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGraphStreamingWrite
extends TigerGraphWriteBase
implements StreamingWrite {
    private static final Logger logger = LoggerFactory.getLogger(TigerGraphStreamingWrite.class);

    TigerGraphStreamingWrite(StructType schema, TigerGraphConnection conn) {
        super(schema, conn);
    }

    public TigerGraphStreamWriterFactory createStreamingWriterFactory(PhysicalWriteInfo info) {
        return new TigerGraphStreamWriterFactory(this.schema, this.conn);
    }

    public void commit(long epochId, WriterCommitMessage[] messages) {
        logger.info("Finished writing streaming updates({}) to TigerGraph {}", (Object)epochId, (Object)(this.conn.getLoadingJobId() == null ? "" : ", Job ID: " + this.conn.getLoadingJobId()));
        logger.info("Total processed rows by this update: {}", (Object)this.getTotalProcessedRows(messages));
        logger.info("Processed rows of each task by this update:\n{}", (Object)this.getTaskSummury(messages));
        RestppResponse resp = this.getLoadingStatistics();
        if (resp != null) {
            Utils.removeUserData(resp.results);
            logger.info("The up-to-date overall loading statistics: {}", (Object)resp.results.toPrettyString());
        }
    }

    public void abort(long epochId, WriterCommitMessage[] messages) {
        logger.error("Aborted when writing streaming updates({}) to TigerGraph {}", (Object)epochId, (Object)(this.conn.getLoadingJobId() == null ? "" : ", Job ID: " + this.conn.getLoadingJobId()));
        logger.info("Total processed rows by this update: {}", (Object)this.getTotalProcessedRows(messages));
        logger.info("Processed rows of each task by this update:\n{}", (Object)this.getTaskSummury(messages));
        RestppResponse resp = this.getLoadingStatistics();
        if (resp != null) {
            Utils.removeUserData(resp.results);
            logger.info("The overall loading statistics: {}", (Object)resp.results.toPrettyString());
        }
    }
}

