/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.write;

import com.tigergraph.spark.TigerGraphConnection;
import com.tigergraph.spark.client.common.RestppResponse;
import com.tigergraph.spark.util.Utils;
import com.tigergraph.spark.write.TigerGraphWriterCommitMessage;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGraphWriteBase {
    private static final Logger logger = LoggerFactory.getLogger(TigerGraphWriteBase.class);
    protected static String GSQL_GET_PROGRESS = "getprogress";
    protected final StructType schema;
    protected final TigerGraphConnection conn;

    public TigerGraphWriteBase(StructType schema, TigerGraphConnection conn) {
        this.schema = schema;
        this.conn = conn;
    }

    protected RestppResponse getLoadingStatistics() {
        if (Utils.versionCmp(this.conn.getVersion(), "3.9.4") >= 0) {
            try {
                RestppResponse resp = this.conn.getMisc().loadingAction(GSQL_GET_PROGRESS, this.conn.getGraph(), this.conn.getLoadingJobId());
                resp.panicOnFail();
                return resp;
            }
            catch (Exception e) {
                logger.info("Failed to query loading statistics of job {}: {}, it won't block the loading and you can manually query it via `curl -X GET -u <username>:<password> \"localhost:8123/gsql/loading-jobs?action=getprogress&jobId={}&graph={}\"", new Object[]{this.conn.getLoadingJobId(), e.getMessage(), this.conn.getLoadingJobId(), this.conn.getGraph()});
            }
        }
        return null;
    }

    protected long getTotalProcessedRows(WriterCommitMessage[] messages) {
        return Arrays.stream(messages).filter(msg -> msg != null && msg instanceof TigerGraphWriterCommitMessage).map(msg -> ((TigerGraphWriterCommitMessage)msg).getLoadedRows()).reduce(0L, (a, b) -> a + b);
    }

    protected String getTaskSummury(WriterCommitMessage[] messages) {
        return Arrays.stream(messages).filter(msg -> msg != null && msg instanceof TigerGraphWriterCommitMessage).map(msg -> msg.toString()).collect(Collectors.joining("\n"));
    }
}

