/*
 * Decompiled with CFR 0.152.
 */
package com.tigergraph.spark.write;

import com.tigergraph.spark.TigerGraphConnection;
import com.tigergraph.spark.util.Options;
import com.tigergraph.spark.write.TigerGraphBatchWrite;
import com.tigergraph.spark.write.TigerGraphStreamingWrite;
import java.time.Instant;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGraphWriteBuilder
implements WriteBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TigerGraphWriteBuilder.class);
    private final StructType schema;
    private final TigerGraphConnection conn;

    public TigerGraphWriteBuilder(LogicalWriteInfo info, long creationTime) {
        logger.info("Start to build TigerGraph data writer with queryId {}", (Object)info.queryId());
        this.schema = info.schema();
        Options opts = new Options(info.options().asCaseSensitiveMap(), Options.OptionType.WRITE);
        opts.validate();
        this.conn = new TigerGraphConnection(opts, creationTime);
        if (this.conn.getLoadingJobId() != null) {
            logger.info("Loading job ID: {}", (Object)this.conn.getLoadingJobId());
        }
    }

    public TigerGraphWriteBuilder(LogicalWriteInfo info) {
        this(info, Instant.now().toEpochMilli());
    }

    public TigerGraphBatchWrite buildForBatch() {
        return new TigerGraphBatchWrite(this.schema, this.conn);
    }

    public TigerGraphStreamingWrite buildForStreaming() {
        return new TigerGraphStreamingWrite(this.schema, this.conn);
    }
}

