/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.isession;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import shaded.org.apache.iotdb.common.rpc.thrift.TAggregationType;
import shaded.org.apache.iotdb.common.rpc.thrift.TEndPoint;
import shaded.org.apache.iotdb.isession.INodeSupplier;
import shaded.org.apache.iotdb.isession.SessionDataSet;
import shaded.org.apache.iotdb.isession.template.Template;
import shaded.org.apache.iotdb.isession.util.SystemStatus;
import shaded.org.apache.iotdb.isession.util.Version;
import shaded.org.apache.iotdb.rpc.IoTDBConnectionException;
import shaded.org.apache.iotdb.rpc.RedirectException;
import shaded.org.apache.iotdb.rpc.StatementExecutionException;
import shaded.org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import shaded.org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import shaded.org.apache.thrift.TException;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.IDeviceID;
import shaded.org.apache.tsfile.file.metadata.enums.CompressionType;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;
import shaded.org.apache.tsfile.write.record.Tablet;

public interface ISession
extends AutoCloseable {
    public Version getVersion();

    public void setVersion(Version var1);

    public int getFetchSize();

    public void setFetchSize(int var1);

    public void open() throws IoTDBConnectionException;

    public void open(boolean var1) throws IoTDBConnectionException;

    public void open(boolean var1, int var2) throws IoTDBConnectionException;

    public void open(boolean var1, int var2, Map<String, TEndPoint> var3, INodeSupplier var4) throws IoTDBConnectionException;

    public void open(boolean var1, int var2, Map<String, TEndPoint> var3, Map<IDeviceID, TEndPoint> var4, INodeSupplier var5) throws IoTDBConnectionException;

    @Override
    public void close() throws IoTDBConnectionException;

    public String getTimeZone() throws IoTDBConnectionException;

    public void setTimeZone(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public void setTimeZoneOfSession(String var1) throws IoTDBConnectionException;

    @Deprecated
    public void setStorageGroup(String var1) throws IoTDBConnectionException, StatementExecutionException;

    @Deprecated
    public void deleteStorageGroup(String var1) throws IoTDBConnectionException, StatementExecutionException;

    @Deprecated
    public void deleteStorageGroups(List<String> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void createDatabase(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteDatabase(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteDatabases(List<String> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void createTimeseries(String var1, TSDataType var2, TSEncoding var3, CompressionType var4) throws IoTDBConnectionException, StatementExecutionException;

    public void createTimeseries(String var1, TSDataType var2, TSEncoding var3, CompressionType var4, Map<String, String> var5, Map<String, String> var6, Map<String, String> var7, String var8) throws IoTDBConnectionException, StatementExecutionException;

    public void createAlignedTimeseries(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5, List<String> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void createAlignedTimeseries(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5, List<String> var6, List<Map<String, String>> var7, List<Map<String, String>> var8) throws IoTDBConnectionException, StatementExecutionException;

    public void createMultiTimeseries(List<String> var1, List<TSDataType> var2, List<TSEncoding> var3, List<CompressionType> var4, List<Map<String, String>> var5, List<Map<String, String>> var6, List<Map<String, String>> var7, List<String> var8) throws IoTDBConnectionException, StatementExecutionException;

    public boolean checkTimeseriesExists(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public SessionDataSet executeQueryStatement(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeQueryStatement(String var1, long var2) throws StatementExecutionException, IoTDBConnectionException;

    public void executeNonQueryStatement(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public SessionDataSet executeRawDataQuery(List<String> var1, long var2, long var4, long var6) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeRawDataQuery(List<String> var1, long var2, long var4) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeLastDataQuery(List<String> var1, long var2) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeLastDataQuery(List<String> var1, long var2, long var4) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeLastDataQuery(List<String> var1) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeFastLastDataQueryForOnePrefixPath(List<String> var1) throws IoTDBConnectionException, StatementExecutionException, RedirectException;

    public SessionDataSet executeLastDataQueryForOneDevice(String var1, String var2, List<String> var3, boolean var4) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeAggregationQuery(List<String> var1, List<TAggregationType> var2) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeAggregationQuery(List<String> var1, List<TAggregationType> var2, long var3, long var5) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeAggregationQuery(List<String> var1, List<TAggregationType> var2, long var3, long var5, long var7) throws StatementExecutionException, IoTDBConnectionException;

    public SessionDataSet executeAggregationQuery(List<String> var1, List<TAggregationType> var2, long var3, long var5, long var7, long var9) throws StatementExecutionException, IoTDBConnectionException;

    public void insertRecord(String var1, long var2, List<String> var4, List<TSDataType> var5, Object ... var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecord(String var1, long var2, List<String> var4, List<TSDataType> var5, List<Object> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecord(String var1, long var2, List<String> var4, List<TSDataType> var5, List<Object> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecord(String var1, long var2, List<String> var4, List<String> var5) throws IoTDBConnectionException, StatementExecutionException;

    public String getTimestampPrecision() throws TException, IoTDBConnectionException;

    public void insertAlignedRecord(String var1, long var2, List<String> var4, List<String> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5, boolean var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4, boolean var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5, boolean var6) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4, boolean var5) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedStringRecordsOfOneDevice(String var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void insertTablet(Tablet var1) throws StatementExecutionException, IoTDBConnectionException;

    public void insertTablet(Tablet var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedTablet(Tablet var1) throws StatementExecutionException, IoTDBConnectionException;

    public void insertAlignedTablet(Tablet var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void insertTablets(Map<String, Tablet> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void insertTablets(Map<String, Tablet> var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedTablets(Map<String, Tablet> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void insertAlignedTablets(Map<String, Tablet> var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertTablet(Tablet var1) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertTablet(Tablet var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertTablets(Map<String, Tablet> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertTablets(Map<String, Tablet> var1, boolean var2) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<String>> var4) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecords(List<String> var1, List<Long> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<Object>> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecord(String var1, long var2, List<String> var4, List<String> var5) throws IoTDBConnectionException, StatementExecutionException;

    public void testInsertRecord(String var1, long var2, List<String> var4, List<TSDataType> var5, List<Object> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteTimeseries(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteTimeseries(List<String> var1) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteData(String var1, long var2) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteData(List<String> var1, long var2) throws IoTDBConnectionException, StatementExecutionException;

    public void deleteData(List<String> var1, long var2, long var4) throws IoTDBConnectionException, StatementExecutionException;

    public void setSchemaTemplate(String var1, String var2) throws IoTDBConnectionException, StatementExecutionException;

    public void createSchemaTemplate(Template var1) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void createSchemaTemplate(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5, boolean var6) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void createSchemaTemplate(String var1, List<String> var2, List<List<String>> var3, List<List<TSDataType>> var4, List<List<TSEncoding>> var5, List<CompressionType> var6) throws IoTDBConnectionException, StatementExecutionException;

    public void addAlignedMeasurementsInTemplate(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void addAlignedMeasurementInTemplate(String var1, String var2, TSDataType var3, TSEncoding var4, CompressionType var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void addUnalignedMeasurementsInTemplate(String var1, List<String> var2, List<TSDataType> var3, List<TSEncoding> var4, List<CompressionType> var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void addUnalignedMeasurementInTemplate(String var1, String var2, TSDataType var3, TSEncoding var4, CompressionType var5) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public void deleteNodeInTemplate(String var1, String var2) throws IOException, IoTDBConnectionException, StatementExecutionException;

    public int countMeasurementsInTemplate(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public boolean isMeasurementInTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public boolean isPathExistInTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showMeasurementsInTemplate(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showMeasurementsInTemplate(String var1, String var2) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showAllTemplates() throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showPathsTemplateSetOn(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public List<String> showPathsTemplateUsingOn(String var1) throws StatementExecutionException, IoTDBConnectionException;

    public void unsetSchemaTemplate(String var1, String var2) throws IoTDBConnectionException, StatementExecutionException;

    public void dropSchemaTemplate(String var1) throws IoTDBConnectionException, StatementExecutionException;

    public void createTimeseriesUsingSchemaTemplate(List<String> var1) throws IoTDBConnectionException, StatementExecutionException;

    public boolean isEnableQueryRedirection();

    public void setEnableQueryRedirection(boolean var1);

    public boolean isEnableRedirection();

    public void setEnableRedirection(boolean var1);

    public void sortTablet(Tablet var1);

    public TSBackupConfigurationResp getBackupConfiguration() throws IoTDBConnectionException, StatementExecutionException;

    public TSConnectionInfoResp fetchAllConnections() throws IoTDBConnectionException;

    public void setQueryTimeout(long var1);

    public long getQueryTimeout();

    @Deprecated
    default public SystemStatus getSystemStatus() {
        return SystemStatus.NORMAL;
    }

    @Deprecated
    default public void createTimeseriesOfTemplateOnPath(String path) throws IoTDBConnectionException, StatementExecutionException {
    }

    @Deprecated
    default public void deactivateTemplateOn(String templateName, String prefixPath) throws IoTDBConnectionException, StatementExecutionException {
    }

    @Deprecated
    default public void operationSyncTransmit(ByteBuffer buffer) throws IoTDBConnectionException, StatementExecutionException {
    }

    @Deprecated
    default public boolean isEnableCacheLeader() {
        return true;
    }

    @Deprecated
    default public void setEnableCacheLeader(boolean enableCacheLeader) {
    }
}

