/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.isession;

import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import shaded.org.apache.iotdb.isession.ISessionDataSet;
import shaded.org.apache.iotdb.rpc.IoTDBConnectionException;
import shaded.org.apache.iotdb.rpc.IoTDBRpcDataSet;
import shaded.org.apache.iotdb.rpc.StatementExecutionException;
import shaded.org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import shaded.org.apache.thrift.TException;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.read.common.Field;
import shaded.org.apache.tsfile.read.common.RowRecord;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.write.UnSupportedDataTypeException;

public class SessionDataSet
implements ISessionDataSet {
    private final IoTDBRpcDataSet ioTDBRpcDataSet;

    public SessionDataSet(String sql, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, long queryId, long statementId, IClientRPCService.Iface client, long sessionId, List<ByteBuffer> queryResult, boolean ignoreTimeStamp, boolean moreData, ZoneId zoneId, int timeFactor, boolean tableModel, List<Integer> columnIndex2TsBlockColumnIndexList) {
        this.ioTDBRpcDataSet = new IoTDBRpcDataSet(sql, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, moreData, queryId, statementId, client, sessionId, queryResult, 5000, 0L, zoneId, "default", timeFactor, tableModel, columnIndex2TsBlockColumnIndexList);
    }

    public SessionDataSet(String sql, List<String> columnNameList, List<String> columnTypeList, Map<String, Integer> columnNameIndex, long queryId, long statementId, IClientRPCService.Iface client, long sessionId, List<ByteBuffer> queryResult, boolean ignoreTimeStamp, long timeout, boolean moreData, int fetchSize, ZoneId zoneId, int timeFactor, boolean tableModel, List<Integer> columnIndex2TsBlockColumnIndexList) {
        this.ioTDBRpcDataSet = new IoTDBRpcDataSet(sql, columnNameList, columnTypeList, columnNameIndex, ignoreTimeStamp, moreData, queryId, statementId, client, sessionId, queryResult, fetchSize, timeout, zoneId, "default", timeFactor, tableModel, columnIndex2TsBlockColumnIndexList);
    }

    public int getFetchSize() {
        return this.ioTDBRpcDataSet.getFetchSize();
    }

    public void setFetchSize(int fetchSize) {
        this.ioTDBRpcDataSet.setFetchSize(fetchSize);
    }

    @Override
    public List<String> getColumnNames() {
        return new ArrayList<String>(this.ioTDBRpcDataSet.getColumnNameList());
    }

    @Override
    public List<String> getColumnTypes() {
        return new ArrayList<String>(this.ioTDBRpcDataSet.getColumnTypeList());
    }

    @Override
    public boolean hasNext() throws StatementExecutionException, IoTDBConnectionException {
        if (this.ioTDBRpcDataSet.hasCachedRecord()) {
            return true;
        }
        return this.ioTDBRpcDataSet.next();
    }

    private RowRecord constructRowRecordFromValueArray() throws StatementExecutionException {
        ArrayList<Field> outFields = new ArrayList<Field>();
        for (int i = this.ioTDBRpcDataSet.getValueColumnStartIndex(); i < this.ioTDBRpcDataSet.getColumnSize(); ++i) {
            Field field;
            String columnName = this.ioTDBRpcDataSet.getColumnNameList().get(i);
            if (!this.ioTDBRpcDataSet.isNull(columnName)) {
                TSDataType dataType = this.ioTDBRpcDataSet.getDataType(columnName);
                field = new Field(dataType);
                switch (dataType) {
                    case BOOLEAN: {
                        boolean booleanValue = this.ioTDBRpcDataSet.getBoolean(columnName);
                        field.setBoolV(booleanValue);
                        break;
                    }
                    case INT32: 
                    case DATE: {
                        int intValue = this.ioTDBRpcDataSet.getInt(columnName);
                        field.setIntV(intValue);
                        break;
                    }
                    case INT64: 
                    case TIMESTAMP: {
                        long longValue = this.ioTDBRpcDataSet.getLong(columnName);
                        field.setLongV(longValue);
                        break;
                    }
                    case FLOAT: {
                        float floatValue = this.ioTDBRpcDataSet.getFloat(columnName);
                        field.setFloatV(floatValue);
                        break;
                    }
                    case DOUBLE: {
                        double doubleValue = this.ioTDBRpcDataSet.getDouble(columnName);
                        field.setDoubleV(doubleValue);
                        break;
                    }
                    case TEXT: 
                    case BLOB: 
                    case STRING: {
                        field.setBinaryV(this.ioTDBRpcDataSet.getBinary(columnName));
                        break;
                    }
                    default: {
                        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", new Object[]{dataType}));
                    }
                }
            } else {
                field = new Field(null);
            }
            outFields.add(field);
        }
        return new RowRecord(this.ioTDBRpcDataSet.getCurrentRowTime(), outFields);
    }

    @Override
    public RowRecord next() throws StatementExecutionException, IoTDBConnectionException {
        if (!this.ioTDBRpcDataSet.hasCachedRecord() && !this.hasNext()) {
            return null;
        }
        this.ioTDBRpcDataSet.setHasCachedRecord(false);
        return this.constructRowRecordFromValueArray();
    }

    public void closeOperationHandle() throws StatementExecutionException, IoTDBConnectionException {
        try {
            this.ioTDBRpcDataSet.close();
        }
        catch (TException e) {
            throw new IoTDBConnectionException(e.getMessage());
        }
    }

    public DataIterator iterator() {
        return new DataIterator();
    }

    @Override
    public void close() throws IoTDBConnectionException, StatementExecutionException {
        this.closeOperationHandle();
    }

    public class DataIterator {
        public boolean next() throws StatementExecutionException, IoTDBConnectionException {
            return SessionDataSet.this.ioTDBRpcDataSet.next();
        }

        public boolean isNull(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.isNull(columnIndex);
        }

        public boolean isNull(String columnName) {
            return SessionDataSet.this.ioTDBRpcDataSet.isNull(columnName);
        }

        public boolean getBoolean(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getBoolean(columnIndex);
        }

        public boolean getBoolean(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getBoolean(columnName);
        }

        public double getDouble(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getDouble(columnIndex);
        }

        public double getDouble(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getDouble(columnName);
        }

        public float getFloat(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getFloat(columnIndex);
        }

        public float getFloat(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getFloat(columnName);
        }

        public int getInt(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getInt(columnIndex);
        }

        public int getInt(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getInt(columnName);
        }

        public long getLong(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getLong(columnIndex);
        }

        public long getLong(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getLong(columnName);
        }

        public Object getObject(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getObject(columnIndex);
        }

        public Object getObject(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getObject(columnName);
        }

        public String getString(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getString(columnIndex);
        }

        public String getString(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getString(columnName);
        }

        public Timestamp getTimestamp(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getTimestamp(columnIndex);
        }

        public Timestamp getTimestamp(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getTimestamp(columnName);
        }

        public LocalDate getDate(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getDate(columnIndex);
        }

        public LocalDate getDate(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getDate(columnName);
        }

        public Binary getBlob(int columnIndex) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getBinary(columnIndex);
        }

        public Binary getBlob(String columnName) throws StatementExecutionException {
            return SessionDataSet.this.ioTDBRpcDataSet.getBinary(columnName);
        }

        public int findColumn(String columnName) {
            return SessionDataSet.this.ioTDBRpcDataSet.findColumn(columnName);
        }

        public List<String> getColumnNameList() {
            return SessionDataSet.this.ioTDBRpcDataSet.getColumnNameList();
        }

        public List<String> getColumnTypeList() {
            return SessionDataSet.this.ioTDBRpcDataSet.getColumnTypeList();
        }
    }
}

