/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.isession.template;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import shaded.org.apache.iotdb.isession.template.TemplateNode;
import shaded.org.apache.iotdb.rpc.StatementExecutionException;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class Template {
    private String name;
    private Map<String, TemplateNode> children;
    private boolean shareTime;

    public Template(String name, boolean isShareTime) {
        this.name = name;
        this.children = new HashMap<String, TemplateNode>();
        this.shareTime = isShareTime;
    }

    public Template(String name) {
        this(name, false);
    }

    public String getName() {
        return this.name;
    }

    public boolean isShareTime() {
        return this.shareTime;
    }

    public void setShareTime(boolean shareTime) {
        this.shareTime = shareTime;
    }

    public void addToTemplate(TemplateNode child) throws StatementExecutionException {
        if (this.children.containsKey(child.getName())) {
            throw new StatementExecutionException("Duplicated child of node in template.");
        }
        this.children.put(child.getName(), child);
    }

    public void deleteFromTemplate(String name) throws StatementExecutionException {
        if (!this.children.containsKey(name)) {
            throw new StatementExecutionException("It is not a direct child of the template: " + name);
        }
        this.children.remove(name);
    }

    public void serialize(OutputStream baos) throws IOException {
        ArrayDeque<Pair<String, TemplateNode>> stack = new ArrayDeque<Pair<String, TemplateNode>>();
        HashSet<String> alignedPrefix = new HashSet<String>();
        ReadWriteIOUtils.write(this.getName(), baos);
        ReadWriteIOUtils.write((Boolean)this.isShareTime(), baos);
        if (this.isShareTime()) {
            alignedPrefix.add("");
        }
        for (TemplateNode child : this.children.values()) {
            stack.push(new Pair<String, TemplateNode>("", child));
        }
        while (!stack.isEmpty()) {
            Pair cur = (Pair)stack.pop();
            String prefix = (String)cur.left;
            TemplateNode curNode = (TemplateNode)cur.right;
            StringBuilder fullPath = new StringBuilder(prefix);
            if (!curNode.isMeasurement()) {
                if (!"".equals(prefix)) {
                    fullPath.append(".");
                }
                fullPath.append(curNode.getName());
                if (curNode.isShareTime()) {
                    alignedPrefix.add(fullPath.toString());
                }
                for (TemplateNode child : curNode.getChildren().values()) {
                    stack.push(new Pair<String, TemplateNode>(fullPath.toString(), child));
                }
                continue;
            }
            ReadWriteIOUtils.write(prefix, baos);
            boolean contains = alignedPrefix.contains(prefix);
            ReadWriteIOUtils.write((Boolean)contains, baos);
            curNode.serialize(baos);
        }
    }
}

