/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.pipe.api.customizer.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import shaded.org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import shaded.org.apache.iotdb.pipe.api.exception.PipeAttributeNotProvidedException;
import shaded.org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;

public class PipeParameterValidator {
    private final PipeParameters parameters;

    public PipeParameterValidator(PipeParameters parameters) {
        this.parameters = parameters;
    }

    public PipeParameters getParameters() {
        return this.parameters;
    }

    public PipeParameterValidator validateSynonymAttributes(List<String> lhsAttributes, List<String> rhsAttributes, boolean isRequired) {
        boolean lhsExistence = lhsAttributes.stream().anyMatch(this.parameters::hasAttribute);
        boolean rhsExistence = rhsAttributes.stream().anyMatch(this.parameters::hasAttribute);
        if (lhsExistence && rhsExistence) {
            throw new PipeParameterNotValidException(String.format("Cannot specify both %s and %s at the same time", lhsAttributes, rhsAttributes));
        }
        if (isRequired && !lhsExistence && !rhsExistence) {
            throw new PipeAttributeNotProvidedException(Stream.concat(lhsAttributes.stream(), rhsAttributes.stream()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList)).toString());
        }
        return this;
    }

    public PipeParameterValidator validateRequiredAttribute(String key) throws PipeAttributeNotProvidedException {
        if (!this.parameters.hasAttribute(key)) {
            throw new PipeAttributeNotProvidedException(key);
        }
        return this;
    }

    public PipeParameterValidator validateAttributeValueRange(String key, boolean canBeOptional, String ... optionalValues) throws PipeAttributeNotProvidedException {
        if (!this.parameters.hasAttribute(key)) {
            if (!canBeOptional) {
                throw new PipeParameterNotValidException(String.format("Parameter %s should be set.", key));
            }
            return this;
        }
        String actualValue = this.parameters.getStringByKeys(key);
        for (String optionalValue : optionalValues) {
            if (!actualValue.equals(optionalValue)) continue;
            return this;
        }
        throw new PipeParameterNotValidException(String.format("Invalid value %s of %s. The value should be one of %s", actualValue, key, Arrays.toString(optionalValues)));
    }

    public PipeParameterValidator validate(SingleObjectValidationRule validationRule, String messageToThrow, Object argument) throws PipeParameterNotValidException {
        if (!validationRule.validate(argument)) {
            throw new PipeParameterNotValidException(messageToThrow);
        }
        return this;
    }

    public PipeParameterValidator validate(MultipleObjectsValidationRule validationRule, String messageToThrow, Object ... arguments) throws PipeParameterNotValidException {
        if (!validationRule.validate(arguments)) {
            throw new PipeParameterNotValidException(messageToThrow);
        }
        return this;
    }

    public static interface SingleObjectValidationRule {
        public boolean validate(Object var1);
    }

    public static interface MultipleObjectsValidationRule {
        public boolean validate(Object ... var1);
    }
}

