/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.pipe.api.type;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Binary
implements Comparable<Binary>,
Serializable {
    private static final long serialVersionUID = 1250049718612917815L;
    public static final String STRING_ENCODING = "UTF-8";
    public static final Charset STRING_CHARSET = StandardCharsets.UTF_8;
    private final byte[] values;
    private int hash;
    private boolean hasCalculatedHash;
    private String stringCache;

    public Binary(byte[] v) {
        this.values = v;
    }

    public Binary(String s) {
        this.values = s == null ? null : s.getBytes(STRING_CHARSET);
    }

    public static Binary valueOf(String value) {
        return new Binary(Binary.stringToBytes(value));
    }

    @Override
    public int compareTo(Binary other) {
        if (other == null) {
            if (this.values == null) {
                return 0;
            }
            return 1;
        }
        for (int i = 0; i < this.getLength() && i < other.getLength(); ++i) {
            if (this.values[i] == other.values[i]) {
                continue;
            }
            return this.values[i] - other.values[i];
        }
        return this.getLength() - other.getLength();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((Binary)other) == 0;
    }

    public int hashCode() {
        if (!this.hasCalculatedHash) {
            this.hash = Arrays.hashCode(this.values);
            this.hasCalculatedHash = true;
        }
        return this.hash;
    }

    public int getLength() {
        if (this.values == null) {
            return -1;
        }
        return this.values.length;
    }

    public boolean isNull() {
        return this.values == null;
    }

    public String getStringValue() {
        if (this.values == null) {
            return null;
        }
        if (this.stringCache == null) {
            this.stringCache = new String(this.values, STRING_CHARSET);
        }
        return this.stringCache;
    }

    public String getTextEncodingType() {
        return STRING_ENCODING;
    }

    public String toString() {
        return this.getStringValue();
    }

    public byte[] getValues() {
        return this.values;
    }

    public static byte[] stringToBytes(String str) {
        return str.getBytes(STRING_CHARSET);
    }
}

