/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.rpc;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import shaded.org.apache.iotdb.common.rpc.thrift.TEndPoint;

public class RedirectException
extends IOException {
    private final TEndPoint endPoint;
    private final Map<String, TEndPoint> deviceEndPointMap;
    private final List<TEndPoint> endPointList;

    public RedirectException(TEndPoint endPoint) {
        super("later request in same group will be redirected to " + endPoint.toString());
        this.endPoint = endPoint;
        this.deviceEndPointMap = null;
        this.endPointList = null;
    }

    public RedirectException(Map<String, TEndPoint> deviceEndPointMap) {
        super("later request in same group will be redirected to " + deviceEndPointMap);
        this.endPoint = null;
        this.deviceEndPointMap = deviceEndPointMap;
        this.endPointList = null;
    }

    public RedirectException(List<TEndPoint> endPointList) {
        super("later request in same group will be redirected to " + endPointList);
        this.endPoint = null;
        this.deviceEndPointMap = null;
        this.endPointList = endPointList;
    }

    public TEndPoint getEndPoint() {
        return this.endPoint;
    }

    public Map<String, TEndPoint> getDeviceEndPointMap() {
        return this.deviceEndPointMap;
    }

    public List<TEndPoint> getEndPointList() {
        return this.endPointList;
    }
}

