/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import shaded.org.apache.tsfile.utils.Binary;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class FilePiecePayload
implements SubscriptionPollPayload {
    private transient String fileName;
    private transient long nextWritingOffset;
    private transient byte[] filePiece;

    public String getFileName() {
        return this.fileName;
    }

    public long getNextWritingOffset() {
        return this.nextWritingOffset;
    }

    public byte[] getFilePiece() {
        return this.filePiece;
    }

    public FilePiecePayload() {
    }

    public FilePiecePayload(String fileName, long nextWritingOffset, byte[] filePiece) {
        this.fileName = fileName;
        this.nextWritingOffset = nextWritingOffset;
        this.filePiece = filePiece;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.fileName, (OutputStream)stream);
        ReadWriteIOUtils.write(this.nextWritingOffset, (OutputStream)stream);
        ReadWriteIOUtils.write(new Binary(this.filePiece), (OutputStream)stream);
    }

    @Override
    public SubscriptionPollPayload deserialize(ByteBuffer buffer) {
        this.fileName = ReadWriteIOUtils.readString(buffer);
        this.nextWritingOffset = ReadWriteIOUtils.readLong(buffer);
        int size = ReadWriteIOUtils.readInt(buffer);
        this.filePiece = ReadWriteIOUtils.readBytes(buffer, size);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FilePiecePayload that = (FilePiecePayload)obj;
        return Objects.equals(this.fileName, that.fileName) && Objects.equals(this.nextWritingOffset, that.nextWritingOffset) && Arrays.equals(this.filePiece, that.filePiece);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.nextWritingOffset, Arrays.hashCode(this.filePiece));
    }

    public String toString() {
        return "FilePiecePayload{fileName=" + this.fileName + ", nextWritingOffset=" + this.nextWritingOffset + ", filePiece=" + FilePiecePayload.formatByteArray(this.filePiece, 64) + "}";
    }

    private static String formatByteArray(byte[] filePiece, int maxLength) {
        int length = filePiece.length;
        int displayLength = Math.min(length, maxLength);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < displayLength; ++i) {
            sb.append(String.format("%02x", filePiece[i]));
            if (i >= displayLength - 1) continue;
            sb.append(", ");
        }
        if (length > maxLength) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }
}

