/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.rpc.subscription.payload.poll;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.ErrorPayload;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.FileInitPayload;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.FilePiecePayload;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.FileSealPayload;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponseType;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.TabletsPayload;
import shaded.org.apache.iotdb.rpc.subscription.payload.poll.TerminationPayload;
import shaded.org.apache.tsfile.utils.PublicBAOS;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class SubscriptionPollResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPollResponse.class);
    private final transient short responseType;
    private final transient SubscriptionPollPayload payload;
    private final transient SubscriptionCommitContext commitContext;

    public SubscriptionPollResponse(short responseType, SubscriptionPollPayload payload, SubscriptionCommitContext commitContext) {
        this.responseType = responseType;
        this.payload = payload;
        this.commitContext = commitContext;
    }

    public short getResponseType() {
        return this.responseType;
    }

    public SubscriptionPollPayload getPayload() {
        return this.payload;
    }

    public SubscriptionCommitContext getCommitContext() {
        return this.commitContext;
    }

    public static ByteBuffer serialize(SubscriptionPollResponse response) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
                response.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
    }

    private void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write(this.responseType, (OutputStream)stream);
        this.payload.serialize(stream);
        this.commitContext.serialize(stream);
    }

    public static SubscriptionPollResponse deserialize(ByteBuffer buffer) {
        short responseType = ReadWriteIOUtils.readShort(buffer);
        SubscriptionPollPayload payload = null;
        if (SubscriptionPollResponseType.isValidatedResponseType(responseType)) {
            switch (SubscriptionPollResponseType.valueOf(responseType)) {
                case TABLETS: {
                    payload = new TabletsPayload().deserialize(buffer);
                    break;
                }
                case FILE_INIT: {
                    payload = new FileInitPayload().deserialize(buffer);
                    break;
                }
                case FILE_PIECE: {
                    payload = new FilePiecePayload().deserialize(buffer);
                    break;
                }
                case FILE_SEAL: {
                    payload = new FileSealPayload().deserialize(buffer);
                    break;
                }
                case ERROR: {
                    payload = new ErrorPayload().deserialize(buffer);
                    break;
                }
                case TERMINATION: {
                    payload = new TerminationPayload().deserialize(buffer);
                    break;
                }
                default: {
                    LOGGER.warn("unexpected response type: {}, payload will be null", (Object)responseType);
                    break;
                }
            }
        } else {
            LOGGER.warn("unexpected response type: {}, payload will be null", (Object)responseType);
        }
        SubscriptionCommitContext commitContext = SubscriptionCommitContext.deserialize(buffer);
        return new SubscriptionPollResponse(responseType, payload, commitContext);
    }

    public String toString() {
        return "SubscriptionPollResponse" + this.coreReportMessage();
    }

    protected Map<String, String> coreReportMessage() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("responseType", SubscriptionPollResponseType.valueOf(this.responseType).toString());
        result.put("payload", this.payload.toString());
        result.put("commitContext", this.commitContext.toString());
        return result;
    }
}

