/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.rpc.subscription.payload.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import shaded.org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import shaded.org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import shaded.org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import shaded.org.apache.tsfile.utils.PublicBAOS;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeUnsubscribeReq
extends TPipeSubscribeReq {
    private transient Set<String> topicNames = new HashSet<String>();

    public Set<String> getTopicNames() {
        return this.topicNames;
    }

    public static PipeSubscribeUnsubscribeReq toTPipeSubscribeReq(Set<String> topicNames) throws IOException {
        PipeSubscribeUnsubscribeReq req = new PipeSubscribeUnsubscribeReq();
        req.topicNames = topicNames;
        req.version = PipeSubscribeRequestVersion.VERSION_1.getVersion();
        req.type = PipeSubscribeRequestType.UNSUBSCRIBE.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
            ReadWriteIOUtils.writeObjectSet(topicNames, outputStream);
            req.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return req;
    }

    public static PipeSubscribeUnsubscribeReq fromTPipeSubscribeReq(TPipeSubscribeReq unsubscribeReq) {
        PipeSubscribeUnsubscribeReq req = new PipeSubscribeUnsubscribeReq();
        if (Objects.nonNull(unsubscribeReq.body) && unsubscribeReq.body.hasRemaining()) {
            req.topicNames = ReadWriteIOUtils.readObjectSet(unsubscribeReq.body);
        }
        req.version = unsubscribeReq.version;
        req.type = unsubscribeReq.type;
        req.body = unsubscribeReq.body;
        return req;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeUnsubscribeReq that = (PipeSubscribeUnsubscribeReq)obj;
        return Objects.equals(this.topicNames, that.topicNames) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicNames, this.version, this.type, this.body);
    }
}

