/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.rpc.subscription.payload.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Objects;
import shaded.org.apache.iotdb.common.rpc.thrift.TSStatus;
import shaded.org.apache.iotdb.rpc.RpcUtils;
import shaded.org.apache.iotdb.rpc.TSStatusCode;
import shaded.org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import shaded.org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import shaded.org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import shaded.org.apache.tsfile.utils.PublicBAOS;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeHandshakeResp
extends TPipeSubscribeResp {
    private transient int dataNodeId;
    private transient String consumerId;
    private transient String consumerGroupId;

    public int getDataNodeId() {
        return this.dataNodeId;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public static PipeSubscribeHandshakeResp toTPipeSubscribeResp(TSStatus status, int dataNodeId, String consumerId, String consumerGroupId) {
        PipeSubscribeHandshakeResp resp = new PipeSubscribeHandshakeResp();
        resp.dataNodeId = dataNodeId;
        resp.consumerId = consumerId;
        resp.consumerGroupId = consumerGroupId;
        resp.status = status;
        resp.version = PipeSubscribeResponseVersion.VERSION_1.getVersion();
        resp.type = PipeSubscribeResponseType.ACK.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
            ReadWriteIOUtils.write(dataNodeId, (OutputStream)outputStream);
            ReadWriteIOUtils.write(consumerId, (OutputStream)outputStream);
            ReadWriteIOUtils.write(consumerGroupId, (OutputStream)outputStream);
            resp.body = Collections.singletonList(ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size()));
        }
        catch (IOException e) {
            resp.status = RpcUtils.getStatus(TSStatusCode.SUBSCRIPTION_HANDSHAKE_ERROR, e.getMessage());
            return resp;
        }
        return resp;
    }

    public static PipeSubscribeHandshakeResp fromTPipeSubscribeResp(TPipeSubscribeResp handshakeResp) {
        PipeSubscribeHandshakeResp resp = new PipeSubscribeHandshakeResp();
        if (Objects.nonNull(handshakeResp.body)) {
            for (ByteBuffer byteBuffer : handshakeResp.body) {
                if (!Objects.nonNull(byteBuffer) || !byteBuffer.hasRemaining()) continue;
                resp.dataNodeId = ReadWriteIOUtils.readInt(byteBuffer);
                resp.consumerId = ReadWriteIOUtils.readString(byteBuffer);
                resp.consumerGroupId = ReadWriteIOUtils.readString(byteBuffer);
                break;
            }
        }
        resp.status = handshakeResp.status;
        resp.version = handshakeResp.version;
        resp.type = handshakeResp.type;
        resp.body = handshakeResp.body;
        return resp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeHandshakeResp that = (PipeSubscribeHandshakeResp)obj;
        return Objects.equals(this.dataNodeId, that.dataNodeId) && Objects.equals(this.status, that.status) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dataNodeId, this.status, this.version, this.type, this.body);
    }
}

