/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.rpc.subscription.payload.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import shaded.org.apache.iotdb.common.rpc.thrift.TSStatus;
import shaded.org.apache.iotdb.rpc.subscription.config.TopicConfig;
import shaded.org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import shaded.org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import shaded.org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import shaded.org.apache.tsfile.utils.PublicBAOS;
import shaded.org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeSubscribeUnsubscribeResp
extends TPipeSubscribeResp {
    private transient Map<String, TopicConfig> topics = new HashMap<String, TopicConfig>();

    public Map<String, TopicConfig> getTopics() {
        return this.topics;
    }

    public static PipeSubscribeUnsubscribeResp toTPipeSubscribeResp(TSStatus status) {
        PipeSubscribeUnsubscribeResp resp = new PipeSubscribeUnsubscribeResp();
        resp.status = status;
        resp.version = PipeSubscribeResponseVersion.VERSION_1.getVersion();
        resp.type = PipeSubscribeResponseType.ACK.getType();
        return resp;
    }

    public static PipeSubscribeUnsubscribeResp toTPipeSubscribeResp(TSStatus status, Map<String, TopicConfig> topics) throws IOException {
        PipeSubscribeUnsubscribeResp resp = PipeSubscribeUnsubscribeResp.toTPipeSubscribeResp(status);
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);){
            ReadWriteIOUtils.write(topics.size(), (OutputStream)outputStream);
            for (Map.Entry<String, TopicConfig> entry : topics.entrySet()) {
                ReadWriteIOUtils.write(entry.getKey(), (OutputStream)outputStream);
                entry.getValue().serialize(outputStream);
            }
            resp.body = Collections.singletonList(ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size()));
        }
        return resp;
    }

    public static PipeSubscribeUnsubscribeResp fromTPipeSubscribeResp(TPipeSubscribeResp unsubscribeResp) {
        PipeSubscribeUnsubscribeResp resp = new PipeSubscribeUnsubscribeResp();
        if (Objects.nonNull(unsubscribeResp.body)) {
            for (ByteBuffer byteBuffer : unsubscribeResp.body) {
                if (!Objects.nonNull(byteBuffer) || !byteBuffer.hasRemaining()) continue;
                int size = ReadWriteIOUtils.readInt(byteBuffer);
                HashMap<String, TopicConfig> topics = new HashMap<String, TopicConfig>();
                for (int i = 0; i < size; ++i) {
                    String topicName = ReadWriteIOUtils.readString(byteBuffer);
                    TopicConfig topicConfig = TopicConfig.deserialize(byteBuffer);
                    topics.put(topicName, topicConfig);
                }
                resp.topics = topics;
                break;
            }
        }
        resp.status = unsubscribeResp.status;
        resp.version = unsubscribeResp.version;
        resp.type = unsubscribeResp.type;
        resp.body = unsubscribeResp.body;
        return resp;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeSubscribeUnsubscribeResp that = (PipeSubscribeUnsubscribeResp)obj;
        return Objects.equals(this.topics, that.topics) && Objects.equals(this.status, that.status) && this.version == that.version && this.type == that.type && Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topics, this.status, this.version, this.type, this.body);
    }
}

