/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.service.rpc.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import shaded.org.apache.iotdb.common.rpc.thrift.TAggregationType;
import shaded.org.apache.thrift.EncodingUtils;
import shaded.org.apache.thrift.TBase;
import shaded.org.apache.thrift.TBaseHelper;
import shaded.org.apache.thrift.TException;
import shaded.org.apache.thrift.TFieldIdEnum;
import shaded.org.apache.thrift.annotation.Nullable;
import shaded.org.apache.thrift.meta_data.EnumMetaData;
import shaded.org.apache.thrift.meta_data.FieldMetaData;
import shaded.org.apache.thrift.meta_data.FieldValueMetaData;
import shaded.org.apache.thrift.protocol.TCompactProtocol;
import shaded.org.apache.thrift.protocol.TField;
import shaded.org.apache.thrift.protocol.TProtocol;
import shaded.org.apache.thrift.protocol.TProtocolException;
import shaded.org.apache.thrift.protocol.TProtocolUtil;
import shaded.org.apache.thrift.protocol.TStruct;
import shaded.org.apache.thrift.protocol.TTupleProtocol;
import shaded.org.apache.thrift.scheme.IScheme;
import shaded.org.apache.thrift.scheme.SchemeFactory;
import shaded.org.apache.thrift.scheme.StandardScheme;
import shaded.org.apache.thrift.scheme.TupleScheme;
import shaded.org.apache.thrift.transport.TIOStreamTransport;

public class TSGroupByQueryIntervalReq
implements TBase<TSGroupByQueryIntervalReq, _Fields>,
Serializable,
Cloneable,
Comparable<TSGroupByQueryIntervalReq> {
    private static final TStruct STRUCT_DESC = new TStruct("TSGroupByQueryIntervalReq");
    private static final TField SESSION_ID_FIELD_DESC = new TField("sessionId", 10, 1);
    private static final TField STATEMENT_ID_FIELD_DESC = new TField("statementId", 10, 2);
    private static final TField DEVICE_FIELD_DESC = new TField("device", 11, 3);
    private static final TField MEASUREMENT_FIELD_DESC = new TField("measurement", 11, 4);
    private static final TField DATA_TYPE_FIELD_DESC = new TField("dataType", 8, 5);
    private static final TField AGGREGATION_TYPE_FIELD_DESC = new TField("aggregationType", 8, 6);
    private static final TField DATABASE_FIELD_DESC = new TField("database", 11, 7);
    private static final TField START_TIME_FIELD_DESC = new TField("startTime", 10, 8);
    private static final TField END_TIME_FIELD_DESC = new TField("endTime", 10, 9);
    private static final TField INTERVAL_FIELD_DESC = new TField("interval", 10, 10);
    private static final TField FETCH_SIZE_FIELD_DESC = new TField("fetchSize", 8, 11);
    private static final TField TIMEOUT_FIELD_DESC = new TField("timeout", 10, 12);
    private static final TField IS_ALIGNED_FIELD_DESC = new TField("isAligned", 2, 13);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TSGroupByQueryIntervalReqStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TSGroupByQueryIntervalReqTupleSchemeFactory();
    public long sessionId;
    public long statementId;
    @Nullable
    public String device;
    @Nullable
    public String measurement;
    public int dataType;
    @Nullable
    public TAggregationType aggregationType;
    @Nullable
    public String database;
    public long startTime;
    public long endTime;
    public long interval;
    public int fetchSize;
    public long timeout;
    public boolean isAligned;
    private static final int __SESSIONID_ISSET_ID = 0;
    private static final int __STATEMENTID_ISSET_ID = 1;
    private static final int __DATATYPE_ISSET_ID = 2;
    private static final int __STARTTIME_ISSET_ID = 3;
    private static final int __ENDTIME_ISSET_ID = 4;
    private static final int __INTERVAL_ISSET_ID = 5;
    private static final int __FETCHSIZE_ISSET_ID = 6;
    private static final int __TIMEOUT_ISSET_ID = 7;
    private static final int __ISALIGNED_ISSET_ID = 8;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DATABASE, _Fields.START_TIME, _Fields.END_TIME, _Fields.INTERVAL, _Fields.FETCH_SIZE, _Fields.TIMEOUT, _Fields.IS_ALIGNED};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TSGroupByQueryIntervalReq() {
    }

    public TSGroupByQueryIntervalReq(long sessionId, long statementId, String device, String measurement, int dataType, TAggregationType aggregationType) {
        this();
        this.sessionId = sessionId;
        this.setSessionIdIsSet(true);
        this.statementId = statementId;
        this.setStatementIdIsSet(true);
        this.device = device;
        this.measurement = measurement;
        this.dataType = dataType;
        this.setDataTypeIsSet(true);
        this.aggregationType = aggregationType;
    }

    public TSGroupByQueryIntervalReq(TSGroupByQueryIntervalReq other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.sessionId = other.sessionId;
        this.statementId = other.statementId;
        if (other.isSetDevice()) {
            this.device = other.device;
        }
        if (other.isSetMeasurement()) {
            this.measurement = other.measurement;
        }
        this.dataType = other.dataType;
        if (other.isSetAggregationType()) {
            this.aggregationType = other.aggregationType;
        }
        if (other.isSetDatabase()) {
            this.database = other.database;
        }
        this.startTime = other.startTime;
        this.endTime = other.endTime;
        this.interval = other.interval;
        this.fetchSize = other.fetchSize;
        this.timeout = other.timeout;
        this.isAligned = other.isAligned;
    }

    @Override
    public TSGroupByQueryIntervalReq deepCopy() {
        return new TSGroupByQueryIntervalReq(this);
    }

    @Override
    public void clear() {
        this.setSessionIdIsSet(false);
        this.sessionId = 0L;
        this.setStatementIdIsSet(false);
        this.statementId = 0L;
        this.device = null;
        this.measurement = null;
        this.setDataTypeIsSet(false);
        this.dataType = 0;
        this.aggregationType = null;
        this.database = null;
        this.setStartTimeIsSet(false);
        this.startTime = 0L;
        this.setEndTimeIsSet(false);
        this.endTime = 0L;
        this.setIntervalIsSet(false);
        this.interval = 0L;
        this.setFetchSizeIsSet(false);
        this.fetchSize = 0;
        this.setTimeoutIsSet(false);
        this.timeout = 0L;
        this.setIsAlignedIsSet(false);
        this.isAligned = false;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public TSGroupByQueryIntervalReq setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.setSessionIdIsSet(true);
        return this;
    }

    public void unsetSessionId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetSessionId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setSessionIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public long getStatementId() {
        return this.statementId;
    }

    public TSGroupByQueryIntervalReq setStatementId(long statementId) {
        this.statementId = statementId;
        this.setStatementIdIsSet(true);
        return this;
    }

    public void unsetStatementId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetStatementId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setStatementIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    @Nullable
    public String getDevice() {
        return this.device;
    }

    public TSGroupByQueryIntervalReq setDevice(@Nullable String device) {
        this.device = device;
        return this;
    }

    public void unsetDevice() {
        this.device = null;
    }

    public boolean isSetDevice() {
        return this.device != null;
    }

    public void setDeviceIsSet(boolean value) {
        if (!value) {
            this.device = null;
        }
    }

    @Nullable
    public String getMeasurement() {
        return this.measurement;
    }

    public TSGroupByQueryIntervalReq setMeasurement(@Nullable String measurement) {
        this.measurement = measurement;
        return this;
    }

    public void unsetMeasurement() {
        this.measurement = null;
    }

    public boolean isSetMeasurement() {
        return this.measurement != null;
    }

    public void setMeasurementIsSet(boolean value) {
        if (!value) {
            this.measurement = null;
        }
    }

    public int getDataType() {
        return this.dataType;
    }

    public TSGroupByQueryIntervalReq setDataType(int dataType) {
        this.dataType = dataType;
        this.setDataTypeIsSet(true);
        return this;
    }

    public void unsetDataType() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetDataType() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setDataTypeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    @Nullable
    public TAggregationType getAggregationType() {
        return this.aggregationType;
    }

    public TSGroupByQueryIntervalReq setAggregationType(@Nullable TAggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public void unsetAggregationType() {
        this.aggregationType = null;
    }

    public boolean isSetAggregationType() {
        return this.aggregationType != null;
    }

    public void setAggregationTypeIsSet(boolean value) {
        if (!value) {
            this.aggregationType = null;
        }
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    public TSGroupByQueryIntervalReq setDatabase(@Nullable String database) {
        this.database = database;
        return this;
    }

    public void unsetDatabase() {
        this.database = null;
    }

    public boolean isSetDatabase() {
        return this.database != null;
    }

    public void setDatabaseIsSet(boolean value) {
        if (!value) {
            this.database = null;
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TSGroupByQueryIntervalReq setStartTime(long startTime) {
        this.startTime = startTime;
        this.setStartTimeIsSet(true);
        return this;
    }

    public void unsetStartTime() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 3);
    }

    public boolean isSetStartTime() {
        return EncodingUtils.testBit(this.__isset_bitfield, 3);
    }

    public void setStartTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 3, value);
    }

    public long getEndTime() {
        return this.endTime;
    }

    public TSGroupByQueryIntervalReq setEndTime(long endTime) {
        this.endTime = endTime;
        this.setEndTimeIsSet(true);
        return this;
    }

    public void unsetEndTime() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 4);
    }

    public boolean isSetEndTime() {
        return EncodingUtils.testBit(this.__isset_bitfield, 4);
    }

    public void setEndTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 4, value);
    }

    public long getInterval() {
        return this.interval;
    }

    public TSGroupByQueryIntervalReq setInterval(long interval) {
        this.interval = interval;
        this.setIntervalIsSet(true);
        return this;
    }

    public void unsetInterval() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 5);
    }

    public boolean isSetInterval() {
        return EncodingUtils.testBit(this.__isset_bitfield, 5);
    }

    public void setIntervalIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 5, value);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public TSGroupByQueryIntervalReq setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        this.setFetchSizeIsSet(true);
        return this;
    }

    public void unsetFetchSize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 6);
    }

    public boolean isSetFetchSize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 6);
    }

    public void setFetchSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 6, value);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TSGroupByQueryIntervalReq setTimeout(long timeout) {
        this.timeout = timeout;
        this.setTimeoutIsSet(true);
        return this;
    }

    public void unsetTimeout() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 7);
    }

    public boolean isSetTimeout() {
        return EncodingUtils.testBit(this.__isset_bitfield, 7);
    }

    public void setTimeoutIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 7, value);
    }

    public boolean isIsAligned() {
        return this.isAligned;
    }

    public TSGroupByQueryIntervalReq setIsAligned(boolean isAligned) {
        this.isAligned = isAligned;
        this.setIsAlignedIsSet(true);
        return this;
    }

    public void unsetIsAligned() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 8);
    }

    public boolean isSetIsAligned() {
        return EncodingUtils.testBit(this.__isset_bitfield, 8);
    }

    public void setIsAlignedIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 8, value);
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case SESSION_ID: {
                if (value == null) {
                    this.unsetSessionId();
                    break;
                }
                this.setSessionId((Long)value);
                break;
            }
            case STATEMENT_ID: {
                if (value == null) {
                    this.unsetStatementId();
                    break;
                }
                this.setStatementId((Long)value);
                break;
            }
            case DEVICE: {
                if (value == null) {
                    this.unsetDevice();
                    break;
                }
                this.setDevice((String)value);
                break;
            }
            case MEASUREMENT: {
                if (value == null) {
                    this.unsetMeasurement();
                    break;
                }
                this.setMeasurement((String)value);
                break;
            }
            case DATA_TYPE: {
                if (value == null) {
                    this.unsetDataType();
                    break;
                }
                this.setDataType((Integer)value);
                break;
            }
            case AGGREGATION_TYPE: {
                if (value == null) {
                    this.unsetAggregationType();
                    break;
                }
                this.setAggregationType((TAggregationType)value);
                break;
            }
            case DATABASE: {
                if (value == null) {
                    this.unsetDatabase();
                    break;
                }
                this.setDatabase((String)value);
                break;
            }
            case START_TIME: {
                if (value == null) {
                    this.unsetStartTime();
                    break;
                }
                this.setStartTime((Long)value);
                break;
            }
            case END_TIME: {
                if (value == null) {
                    this.unsetEndTime();
                    break;
                }
                this.setEndTime((Long)value);
                break;
            }
            case INTERVAL: {
                if (value == null) {
                    this.unsetInterval();
                    break;
                }
                this.setInterval((Long)value);
                break;
            }
            case FETCH_SIZE: {
                if (value == null) {
                    this.unsetFetchSize();
                    break;
                }
                this.setFetchSize((Integer)value);
                break;
            }
            case TIMEOUT: {
                if (value == null) {
                    this.unsetTimeout();
                    break;
                }
                this.setTimeout((Long)value);
                break;
            }
            case IS_ALIGNED: {
                if (value == null) {
                    this.unsetIsAligned();
                    break;
                }
                this.setIsAligned((Boolean)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case SESSION_ID: {
                return this.getSessionId();
            }
            case STATEMENT_ID: {
                return this.getStatementId();
            }
            case DEVICE: {
                return this.getDevice();
            }
            case MEASUREMENT: {
                return this.getMeasurement();
            }
            case DATA_TYPE: {
                return this.getDataType();
            }
            case AGGREGATION_TYPE: {
                return this.getAggregationType();
            }
            case DATABASE: {
                return this.getDatabase();
            }
            case START_TIME: {
                return this.getStartTime();
            }
            case END_TIME: {
                return this.getEndTime();
            }
            case INTERVAL: {
                return this.getInterval();
            }
            case FETCH_SIZE: {
                return this.getFetchSize();
            }
            case TIMEOUT: {
                return this.getTimeout();
            }
            case IS_ALIGNED: {
                return this.isIsAligned();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case SESSION_ID: {
                return this.isSetSessionId();
            }
            case STATEMENT_ID: {
                return this.isSetStatementId();
            }
            case DEVICE: {
                return this.isSetDevice();
            }
            case MEASUREMENT: {
                return this.isSetMeasurement();
            }
            case DATA_TYPE: {
                return this.isSetDataType();
            }
            case AGGREGATION_TYPE: {
                return this.isSetAggregationType();
            }
            case DATABASE: {
                return this.isSetDatabase();
            }
            case START_TIME: {
                return this.isSetStartTime();
            }
            case END_TIME: {
                return this.isSetEndTime();
            }
            case INTERVAL: {
                return this.isSetInterval();
            }
            case FETCH_SIZE: {
                return this.isSetFetchSize();
            }
            case TIMEOUT: {
                return this.isSetTimeout();
            }
            case IS_ALIGNED: {
                return this.isSetIsAligned();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TSGroupByQueryIntervalReq) {
            return this.equals((TSGroupByQueryIntervalReq)that);
        }
        return false;
    }

    public boolean equals(TSGroupByQueryIntervalReq that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_sessionId = true;
        boolean that_present_sessionId = true;
        if (this_present_sessionId || that_present_sessionId) {
            if (!this_present_sessionId || !that_present_sessionId) {
                return false;
            }
            if (this.sessionId != that.sessionId) {
                return false;
            }
        }
        boolean this_present_statementId = true;
        boolean that_present_statementId = true;
        if (this_present_statementId || that_present_statementId) {
            if (!this_present_statementId || !that_present_statementId) {
                return false;
            }
            if (this.statementId != that.statementId) {
                return false;
            }
        }
        boolean this_present_device = this.isSetDevice();
        boolean that_present_device = that.isSetDevice();
        if (this_present_device || that_present_device) {
            if (!this_present_device || !that_present_device) {
                return false;
            }
            if (!this.device.equals(that.device)) {
                return false;
            }
        }
        boolean this_present_measurement = this.isSetMeasurement();
        boolean that_present_measurement = that.isSetMeasurement();
        if (this_present_measurement || that_present_measurement) {
            if (!this_present_measurement || !that_present_measurement) {
                return false;
            }
            if (!this.measurement.equals(that.measurement)) {
                return false;
            }
        }
        boolean this_present_dataType = true;
        boolean that_present_dataType = true;
        if (this_present_dataType || that_present_dataType) {
            if (!this_present_dataType || !that_present_dataType) {
                return false;
            }
            if (this.dataType != that.dataType) {
                return false;
            }
        }
        boolean this_present_aggregationType = this.isSetAggregationType();
        boolean that_present_aggregationType = that.isSetAggregationType();
        if (this_present_aggregationType || that_present_aggregationType) {
            if (!this_present_aggregationType || !that_present_aggregationType) {
                return false;
            }
            if (!this.aggregationType.equals(that.aggregationType)) {
                return false;
            }
        }
        boolean this_present_database = this.isSetDatabase();
        boolean that_present_database = that.isSetDatabase();
        if (this_present_database || that_present_database) {
            if (!this_present_database || !that_present_database) {
                return false;
            }
            if (!this.database.equals(that.database)) {
                return false;
            }
        }
        boolean this_present_startTime = this.isSetStartTime();
        boolean that_present_startTime = that.isSetStartTime();
        if (this_present_startTime || that_present_startTime) {
            if (!this_present_startTime || !that_present_startTime) {
                return false;
            }
            if (this.startTime != that.startTime) {
                return false;
            }
        }
        boolean this_present_endTime = this.isSetEndTime();
        boolean that_present_endTime = that.isSetEndTime();
        if (this_present_endTime || that_present_endTime) {
            if (!this_present_endTime || !that_present_endTime) {
                return false;
            }
            if (this.endTime != that.endTime) {
                return false;
            }
        }
        boolean this_present_interval = this.isSetInterval();
        boolean that_present_interval = that.isSetInterval();
        if (this_present_interval || that_present_interval) {
            if (!this_present_interval || !that_present_interval) {
                return false;
            }
            if (this.interval != that.interval) {
                return false;
            }
        }
        boolean this_present_fetchSize = this.isSetFetchSize();
        boolean that_present_fetchSize = that.isSetFetchSize();
        if (this_present_fetchSize || that_present_fetchSize) {
            if (!this_present_fetchSize || !that_present_fetchSize) {
                return false;
            }
            if (this.fetchSize != that.fetchSize) {
                return false;
            }
        }
        boolean this_present_timeout = this.isSetTimeout();
        boolean that_present_timeout = that.isSetTimeout();
        if (this_present_timeout || that_present_timeout) {
            if (!this_present_timeout || !that_present_timeout) {
                return false;
            }
            if (this.timeout != that.timeout) {
                return false;
            }
        }
        boolean this_present_isAligned = this.isSetIsAligned();
        boolean that_present_isAligned = that.isSetIsAligned();
        if (this_present_isAligned || that_present_isAligned) {
            if (!this_present_isAligned || !that_present_isAligned) {
                return false;
            }
            if (this.isAligned != that.isAligned) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.sessionId);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.statementId);
        hashCode = hashCode * 8191 + (this.isSetDevice() ? 131071 : 524287);
        if (this.isSetDevice()) {
            hashCode = hashCode * 8191 + this.device.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMeasurement() ? 131071 : 524287);
        if (this.isSetMeasurement()) {
            hashCode = hashCode * 8191 + this.measurement.hashCode();
        }
        hashCode = hashCode * 8191 + this.dataType;
        hashCode = hashCode * 8191 + (this.isSetAggregationType() ? 131071 : 524287);
        if (this.isSetAggregationType()) {
            hashCode = hashCode * 8191 + this.aggregationType.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetDatabase() ? 131071 : 524287);
        if (this.isSetDatabase()) {
            hashCode = hashCode * 8191 + this.database.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStartTime() ? 131071 : 524287);
        if (this.isSetStartTime()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.startTime);
        }
        hashCode = hashCode * 8191 + (this.isSetEndTime() ? 131071 : 524287);
        if (this.isSetEndTime()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.endTime);
        }
        hashCode = hashCode * 8191 + (this.isSetInterval() ? 131071 : 524287);
        if (this.isSetInterval()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.interval);
        }
        hashCode = hashCode * 8191 + (this.isSetFetchSize() ? 131071 : 524287);
        if (this.isSetFetchSize()) {
            hashCode = hashCode * 8191 + this.fetchSize;
        }
        hashCode = hashCode * 8191 + (this.isSetTimeout() ? 131071 : 524287);
        if (this.isSetTimeout()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.timeout);
        }
        hashCode = hashCode * 8191 + (this.isSetIsAligned() ? 131071 : 524287);
        if (this.isSetIsAligned()) {
            hashCode = hashCode * 8191 + (this.isAligned ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TSGroupByQueryIntervalReq other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetSessionId(), other.isSetSessionId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSessionId() && (lastComparison = TBaseHelper.compareTo(this.sessionId, other.sessionId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStatementId(), other.isSetStatementId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStatementId() && (lastComparison = TBaseHelper.compareTo(this.statementId, other.statementId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDevice(), other.isSetDevice());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDevice() && (lastComparison = TBaseHelper.compareTo(this.device, other.device)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMeasurement(), other.isSetMeasurement());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMeasurement() && (lastComparison = TBaseHelper.compareTo(this.measurement, other.measurement)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDataType(), other.isSetDataType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDataType() && (lastComparison = TBaseHelper.compareTo(this.dataType, other.dataType)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAggregationType(), other.isSetAggregationType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAggregationType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.aggregationType), (Comparable)((Object)other.aggregationType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDatabase(), other.isSetDatabase());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDatabase() && (lastComparison = TBaseHelper.compareTo(this.database, other.database)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStartTime(), other.isSetStartTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStartTime() && (lastComparison = TBaseHelper.compareTo(this.startTime, other.startTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEndTime(), other.isSetEndTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEndTime() && (lastComparison = TBaseHelper.compareTo(this.endTime, other.endTime)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetInterval(), other.isSetInterval());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInterval() && (lastComparison = TBaseHelper.compareTo(this.interval, other.interval)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFetchSize(), other.isSetFetchSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFetchSize() && (lastComparison = TBaseHelper.compareTo(this.fetchSize, other.fetchSize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTimeout(), other.isSetTimeout());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeout() && (lastComparison = TBaseHelper.compareTo(this.timeout, other.timeout)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsAligned(), other.isSetIsAligned());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsAligned() && (lastComparison = TBaseHelper.compareTo(this.isAligned, other.isAligned)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TSGroupByQueryIntervalReq.scheme(iprot).read(iprot, (TSGroupByQueryIntervalReq)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TSGroupByQueryIntervalReq.scheme(oprot).write(oprot, (TSGroupByQueryIntervalReq)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TSGroupByQueryIntervalReq(");
        boolean first = true;
        sb.append("sessionId:");
        sb.append(this.sessionId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("statementId:");
        sb.append(this.statementId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("device:");
        if (this.device == null) {
            sb.append("null");
        } else {
            sb.append(this.device);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("measurement:");
        if (this.measurement == null) {
            sb.append("null");
        } else {
            sb.append(this.measurement);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dataType:");
        sb.append(this.dataType);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("aggregationType:");
        if (this.aggregationType == null) {
            sb.append("null");
        } else {
            sb.append(this.aggregationType);
        }
        first = false;
        if (this.isSetDatabase()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("database:");
            if (this.database == null) {
                sb.append("null");
            } else {
                sb.append(this.database);
            }
            first = false;
        }
        if (this.isSetStartTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("startTime:");
            sb.append(this.startTime);
            first = false;
        }
        if (this.isSetEndTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("endTime:");
            sb.append(this.endTime);
            first = false;
        }
        if (this.isSetInterval()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("interval:");
            sb.append(this.interval);
            first = false;
        }
        if (this.isSetFetchSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("fetchSize:");
            sb.append(this.fetchSize);
            first = false;
        }
        if (this.isSetTimeout()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timeout:");
            sb.append(this.timeout);
            first = false;
        }
        if (this.isSetIsAligned()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("isAligned:");
            sb.append(this.isAligned);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.device == null) {
            throw new TProtocolException("Required field 'device' was not present! Struct: " + this.toString());
        }
        if (this.measurement == null) {
            throw new TProtocolException("Required field 'measurement' was not present! Struct: " + this.toString());
        }
        if (this.aggregationType == null) {
            throw new TProtocolException("Required field 'aggregationType' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.SESSION_ID, new FieldMetaData("sessionId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.STATEMENT_ID, new FieldMetaData("statementId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DEVICE, new FieldMetaData("device", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.MEASUREMENT, new FieldMetaData("measurement", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DATA_TYPE, new FieldMetaData("dataType", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.AGGREGATION_TYPE, new FieldMetaData("aggregationType", 1, new EnumMetaData(16, TAggregationType.class)));
        tmpMap.put(_Fields.DATABASE, new FieldMetaData("database", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.START_TIME, new FieldMetaData("startTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.END_TIME, new FieldMetaData("endTime", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.INTERVAL, new FieldMetaData("interval", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.FETCH_SIZE, new FieldMetaData("fetchSize", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.TIMEOUT, new FieldMetaData("timeout", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.IS_ALIGNED, new FieldMetaData("isAligned", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TSGroupByQueryIntervalReq.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        SESSION_ID(1, "sessionId"),
        STATEMENT_ID(2, "statementId"),
        DEVICE(3, "device"),
        MEASUREMENT(4, "measurement"),
        DATA_TYPE(5, "dataType"),
        AGGREGATION_TYPE(6, "aggregationType"),
        DATABASE(7, "database"),
        START_TIME(8, "startTime"),
        END_TIME(9, "endTime"),
        INTERVAL(10, "interval"),
        FETCH_SIZE(11, "fetchSize"),
        TIMEOUT(12, "timeout"),
        IS_ALIGNED(13, "isAligned");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return SESSION_ID;
                }
                case 2: {
                    return STATEMENT_ID;
                }
                case 3: {
                    return DEVICE;
                }
                case 4: {
                    return MEASUREMENT;
                }
                case 5: {
                    return DATA_TYPE;
                }
                case 6: {
                    return AGGREGATION_TYPE;
                }
                case 7: {
                    return DATABASE;
                }
                case 8: {
                    return START_TIME;
                }
                case 9: {
                    return END_TIME;
                }
                case 10: {
                    return INTERVAL;
                }
                case 11: {
                    return FETCH_SIZE;
                }
                case 12: {
                    return TIMEOUT;
                }
                case 13: {
                    return IS_ALIGNED;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }

    private static class TSGroupByQueryIntervalReqStandardSchemeFactory
    implements SchemeFactory {
        private TSGroupByQueryIntervalReqStandardSchemeFactory() {
        }

        public TSGroupByQueryIntervalReqStandardScheme getScheme() {
            return new TSGroupByQueryIntervalReqStandardScheme();
        }
    }

    private static class TSGroupByQueryIntervalReqTupleSchemeFactory
    implements SchemeFactory {
        private TSGroupByQueryIntervalReqTupleSchemeFactory() {
        }

        public TSGroupByQueryIntervalReqTupleScheme getScheme() {
            return new TSGroupByQueryIntervalReqTupleScheme();
        }
    }

    private static class TSGroupByQueryIntervalReqTupleScheme
    extends TupleScheme<TSGroupByQueryIntervalReq> {
        private TSGroupByQueryIntervalReqTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TSGroupByQueryIntervalReq struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.sessionId);
            oprot.writeI64(struct.statementId);
            oprot.writeString(struct.device);
            oprot.writeString(struct.measurement);
            oprot.writeI32(struct.dataType);
            oprot.writeI32(struct.aggregationType.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetDatabase()) {
                optionals.set(0);
            }
            if (struct.isSetStartTime()) {
                optionals.set(1);
            }
            if (struct.isSetEndTime()) {
                optionals.set(2);
            }
            if (struct.isSetInterval()) {
                optionals.set(3);
            }
            if (struct.isSetFetchSize()) {
                optionals.set(4);
            }
            if (struct.isSetTimeout()) {
                optionals.set(5);
            }
            if (struct.isSetIsAligned()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetDatabase()) {
                oprot.writeString(struct.database);
            }
            if (struct.isSetStartTime()) {
                oprot.writeI64(struct.startTime);
            }
            if (struct.isSetEndTime()) {
                oprot.writeI64(struct.endTime);
            }
            if (struct.isSetInterval()) {
                oprot.writeI64(struct.interval);
            }
            if (struct.isSetFetchSize()) {
                oprot.writeI32(struct.fetchSize);
            }
            if (struct.isSetTimeout()) {
                oprot.writeI64(struct.timeout);
            }
            if (struct.isSetIsAligned()) {
                oprot.writeBool(struct.isAligned);
            }
        }

        @Override
        public void read(TProtocol prot, TSGroupByQueryIntervalReq struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.sessionId = iprot.readI64();
            struct.setSessionIdIsSet(true);
            struct.statementId = iprot.readI64();
            struct.setStatementIdIsSet(true);
            struct.device = iprot.readString();
            struct.setDeviceIsSet(true);
            struct.measurement = iprot.readString();
            struct.setMeasurementIsSet(true);
            struct.dataType = iprot.readI32();
            struct.setDataTypeIsSet(true);
            struct.aggregationType = TAggregationType.findByValue(iprot.readI32());
            struct.setAggregationTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.database = iprot.readString();
                struct.setDatabaseIsSet(true);
            }
            if (incoming.get(1)) {
                struct.startTime = iprot.readI64();
                struct.setStartTimeIsSet(true);
            }
            if (incoming.get(2)) {
                struct.endTime = iprot.readI64();
                struct.setEndTimeIsSet(true);
            }
            if (incoming.get(3)) {
                struct.interval = iprot.readI64();
                struct.setIntervalIsSet(true);
            }
            if (incoming.get(4)) {
                struct.fetchSize = iprot.readI32();
                struct.setFetchSizeIsSet(true);
            }
            if (incoming.get(5)) {
                struct.timeout = iprot.readI64();
                struct.setTimeoutIsSet(true);
            }
            if (incoming.get(6)) {
                struct.isAligned = iprot.readBool();
                struct.setIsAlignedIsSet(true);
            }
        }
    }

    private static class TSGroupByQueryIntervalReqStandardScheme
    extends StandardScheme<TSGroupByQueryIntervalReq> {
        private TSGroupByQueryIntervalReqStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TSGroupByQueryIntervalReq struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.sessionId = iprot.readI64();
                            struct.setSessionIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.statementId = iprot.readI64();
                            struct.setStatementIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.device = iprot.readString();
                            struct.setDeviceIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.measurement = iprot.readString();
                            struct.setMeasurementIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.dataType = iprot.readI32();
                            struct.setDataTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 8) {
                            struct.aggregationType = TAggregationType.findByValue(iprot.readI32());
                            struct.setAggregationTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.database = iprot.readString();
                            struct.setDatabaseIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.startTime = iprot.readI64();
                            struct.setStartTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.endTime = iprot.readI64();
                            struct.setEndTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.interval = iprot.readI64();
                            struct.setIntervalIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 8) {
                            struct.fetchSize = iprot.readI32();
                            struct.setFetchSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 10) {
                            struct.timeout = iprot.readI64();
                            struct.setTimeoutIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 2) {
                            struct.isAligned = iprot.readBool();
                            struct.setIsAlignedIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetSessionId()) {
                throw new TProtocolException("Required field 'sessionId' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetStatementId()) {
                throw new TProtocolException("Required field 'statementId' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetDataType()) {
                throw new TProtocolException("Required field 'dataType' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TSGroupByQueryIntervalReq struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(SESSION_ID_FIELD_DESC);
            oprot.writeI64(struct.sessionId);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(STATEMENT_ID_FIELD_DESC);
            oprot.writeI64(struct.statementId);
            oprot.writeFieldEnd();
            if (struct.device != null) {
                oprot.writeFieldBegin(DEVICE_FIELD_DESC);
                oprot.writeString(struct.device);
                oprot.writeFieldEnd();
            }
            if (struct.measurement != null) {
                oprot.writeFieldBegin(MEASUREMENT_FIELD_DESC);
                oprot.writeString(struct.measurement);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(DATA_TYPE_FIELD_DESC);
            oprot.writeI32(struct.dataType);
            oprot.writeFieldEnd();
            if (struct.aggregationType != null) {
                oprot.writeFieldBegin(AGGREGATION_TYPE_FIELD_DESC);
                oprot.writeI32(struct.aggregationType.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.database != null && struct.isSetDatabase()) {
                oprot.writeFieldBegin(DATABASE_FIELD_DESC);
                oprot.writeString(struct.database);
                oprot.writeFieldEnd();
            }
            if (struct.isSetStartTime()) {
                oprot.writeFieldBegin(START_TIME_FIELD_DESC);
                oprot.writeI64(struct.startTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetEndTime()) {
                oprot.writeFieldBegin(END_TIME_FIELD_DESC);
                oprot.writeI64(struct.endTime);
                oprot.writeFieldEnd();
            }
            if (struct.isSetInterval()) {
                oprot.writeFieldBegin(INTERVAL_FIELD_DESC);
                oprot.writeI64(struct.interval);
                oprot.writeFieldEnd();
            }
            if (struct.isSetFetchSize()) {
                oprot.writeFieldBegin(FETCH_SIZE_FIELD_DESC);
                oprot.writeI32(struct.fetchSize);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeout()) {
                oprot.writeFieldBegin(TIMEOUT_FIELD_DESC);
                oprot.writeI64(struct.timeout);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsAligned()) {
                oprot.writeFieldBegin(IS_ALIGNED_FIELD_DESC);
                oprot.writeBool(struct.isAligned);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }
}

