/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.org.apache.iotdb.isession.SessionConfig;
import shaded.org.apache.iotdb.isession.util.Version;
import shaded.org.apache.tsfile.enums.TSDataType;
import shaded.org.apache.tsfile.file.metadata.enums.CompressionType;
import shaded.org.apache.tsfile.file.metadata.enums.TSEncoding;

public abstract class AbstractSessionBuilder {
    public String host = "localhost";
    public int rpcPort = 6667;
    public String username = "root";
    public String pw = "TimechoDB@2021";
    public int fetchSize = 5000;
    public ZoneId zoneId = null;
    public int thriftDefaultBufferSize = 1024;
    public int thriftMaxFrameSize = 0x4000000;
    public boolean enableRedirection = true;
    public boolean enableRecordsAutoConvertTablet = true;
    public Version version = SessionConfig.DEFAULT_VERSION;
    public long timeOut = 60000L;
    public boolean enableAutoFetch = true;
    public boolean useSSL = false;
    public String trustStore;
    public String trustStorePwd;
    public int maxRetryCount = 60;
    public long retryIntervalInMs = 500L;
    public List<String> nodeUrls = null;
    public String sqlDialect = "tree";
    public String database;
    public Boolean isIoTDBRpcCompressionEnabled = true;
    public Boolean isThriftRpcCompactionEnabled = false;
    public CompressionType compressionType = CompressionType.UNCOMPRESSED;
    public Map<TSDataType, TSEncoding> columnEncodersMap = new HashMap<TSDataType, TSEncoding>();
    public int tabletCompressionMinRowSize = 10;

    public AbstractSessionBuilder() {
        this.columnEncodersMap.put(TSDataType.TIMESTAMP, TSEncoding.TS_2DIFF);
        this.columnEncodersMap.put(TSDataType.BOOLEAN, TSEncoding.RLE);
        this.columnEncodersMap.put(TSDataType.INT32, TSEncoding.TS_2DIFF);
        this.columnEncodersMap.put(TSDataType.INT64, TSEncoding.TS_2DIFF);
        this.columnEncodersMap.put(TSDataType.FLOAT, TSEncoding.GORILLA);
        this.columnEncodersMap.put(TSDataType.DOUBLE, TSEncoding.GORILLA);
        this.columnEncodersMap.put(TSDataType.DATE, TSEncoding.TS_2DIFF);
        this.columnEncodersMap.put(TSDataType.STRING, TSEncoding.PLAIN);
        this.columnEncodersMap.put(TSDataType.TEXT, TSEncoding.PLAIN);
        this.columnEncodersMap.put(TSDataType.BLOB, TSEncoding.PLAIN);
    }
}

