/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.iotdb.session;

import java.security.SecureRandom;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.iotdb.common.rpc.thrift.TAggregationType;
import shaded.org.apache.iotdb.common.rpc.thrift.TEndPoint;
import shaded.org.apache.iotdb.common.rpc.thrift.TSStatus;
import shaded.org.apache.iotdb.isession.SessionDataSet;
import shaded.org.apache.iotdb.rpc.DeepCopyRpcTransportFactory;
import shaded.org.apache.iotdb.rpc.IoTDBConnectionException;
import shaded.org.apache.iotdb.rpc.RedirectException;
import shaded.org.apache.iotdb.rpc.RpcUtils;
import shaded.org.apache.iotdb.rpc.StatementExecutionException;
import shaded.org.apache.iotdb.rpc.TSStatusCode;
import shaded.org.apache.iotdb.service.rpc.thrift.IClientRPCService;
import shaded.org.apache.iotdb.service.rpc.thrift.TCreateTimeseriesUsingSchemaTemplateReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSAggregationQueryReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSAppendSchemaTemplateReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSBackupConfigurationResp;
import shaded.org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import shaded.org.apache.iotdb.service.rpc.thrift.TSCreateAlignedTimeseriesReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSCreateMultiTimeseriesReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSCreateSchemaTemplateReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSDropSchemaTemplateReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import shaded.org.apache.iotdb.service.rpc.thrift.TSFastLastDataQueryForOneDeviceReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSFastLastDataQueryForOnePrefixPathReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertRecordReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertRecordsOfOneDeviceReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertRecordsReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsOfOneDeviceReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertStringRecordsReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertTabletReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSInsertTabletsReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSLastDataQueryReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import shaded.org.apache.iotdb.service.rpc.thrift.TSPruneSchemaTemplateReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSQueryTemplateReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSQueryTemplateResp;
import shaded.org.apache.iotdb.service.rpc.thrift.TSRawDataQueryReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSSetSchemaTemplateReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import shaded.org.apache.iotdb.service.rpc.thrift.TSUnsetSchemaTemplateReq;
import shaded.org.apache.iotdb.session.Session;
import shaded.org.apache.iotdb.session.util.SessionUtils;
import shaded.org.apache.thrift.TException;
import shaded.org.apache.thrift.protocol.TBinaryProtocol;
import shaded.org.apache.thrift.protocol.TCompactProtocol;
import shaded.org.apache.thrift.transport.TTransport;
import shaded.org.apache.thrift.transport.TTransportException;
import shaded.org.apache.tsfile.utils.Pair;
import shaded.org.apache.tsfile.utils.Preconditions;

public class SessionConnection {
    private static final Logger logger = LoggerFactory.getLogger(SessionConnection.class);
    public static final String MSG_RECONNECTION_FAIL = "Fail to reconnect to server. Please check server status.";
    protected Session session;
    private TTransport transport;
    protected IClientRPCService.Iface client;
    private long sessionId;
    private long statementId;
    private ZoneId zoneId;
    private TEndPoint endPoint;
    private List<TEndPoint> endPointList = new ArrayList<TEndPoint>();
    private boolean enableRedirect = false;
    private final Supplier<List<TEndPoint>> availableNodes;
    private final int maxRetryCount;
    private final long retryIntervalInMs;
    private String sqlDialect;
    private String database;
    private int timeFactor = 1000;

    public SessionConnection(String sqlDialect) {
        this.availableNodes = Collections::emptyList;
        this.maxRetryCount = Math.max(0, 60);
        this.retryIntervalInMs = Math.max(0L, 500L);
        this.sqlDialect = sqlDialect;
        this.database = null;
    }

    public SessionConnection(Session session, TEndPoint endPoint, ZoneId zoneId, Supplier<List<TEndPoint>> availableNodes, int maxRetryCount, long retryIntervalInMs, String sqlDialect, String database) throws IoTDBConnectionException {
        this.session = session;
        this.endPoint = endPoint;
        this.endPointList.add(endPoint);
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        this.availableNodes = availableNodes;
        this.maxRetryCount = Math.max(0, maxRetryCount);
        this.retryIntervalInMs = Math.max(0L, retryIntervalInMs);
        this.sqlDialect = sqlDialect;
        this.database = database;
        try {
            this.init(endPoint, session.useSSL, session.trustStore, session.trustStorePwd);
        }
        catch (StatementExecutionException e) {
            throw new IoTDBConnectionException(e.getMessage());
        }
        catch (IoTDBConnectionException e) {
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    public SessionConnection(Session session, ZoneId zoneId, Supplier<List<TEndPoint>> availableNodes, int maxRetryCount, long retryIntervalInMs, String sqlDialect, String database) throws IoTDBConnectionException {
        this.session = session;
        this.zoneId = zoneId == null ? ZoneId.systemDefault() : zoneId;
        this.endPointList = SessionUtils.parseSeedNodeUrls(session.nodeUrls);
        this.availableNodes = availableNodes;
        this.maxRetryCount = Math.max(0, maxRetryCount);
        this.retryIntervalInMs = Math.max(0L, retryIntervalInMs);
        this.sqlDialect = sqlDialect;
        this.database = database;
        this.initClusterConn();
    }

    private void init(TEndPoint endPoint, boolean useSSL, String trustStore, String trustStorePwd) throws IoTDBConnectionException, StatementExecutionException {
        DeepCopyRpcTransportFactory.setDefaultBufferCapacity(this.session.thriftDefaultBufferSize);
        DeepCopyRpcTransportFactory.setThriftMaxFrameSize(this.session.thriftMaxFrameSize);
        try {
            if (this.transport != null && this.transport.isOpen()) {
                this.close();
            }
            this.transport = useSSL ? DeepCopyRpcTransportFactory.INSTANCE.getTransport(endPoint.getIp(), endPoint.getPort(), this.session.connectionTimeoutInMs, trustStore, trustStorePwd) : DeepCopyRpcTransportFactory.INSTANCE.getTransport(endPoint.getIp(), endPoint.getPort(), this.session.connectionTimeoutInMs);
            if (!this.transport.isOpen()) {
                this.transport.open();
            }
        }
        catch (TTransportException e) {
            throw new IoTDBConnectionException(e);
        }
        this.client = this.session.enableThriftRpcCompaction ? new IClientRPCService.Client(new TCompactProtocol(this.transport)) : new IClientRPCService.Client(new TBinaryProtocol(this.transport));
        this.client = RpcUtils.newSynchronizedClient(this.client);
        TSOpenSessionReq openReq = new TSOpenSessionReq();
        openReq.setUsername(this.session.username);
        openReq.setPassword(this.session.password);
        openReq.setZoneId(this.zoneId.toString());
        openReq.putToConfiguration("version", this.session.version.toString());
        openReq.putToConfiguration("sql_dialect", this.sqlDialect);
        if (this.database != null) {
            openReq.putToConfiguration("db", this.database);
        }
        try {
            TSOpenSessionResp openResp = this.client.openSession(openReq);
            RpcUtils.verifySuccess(openResp.getStatus());
            this.timeFactor = RpcUtils.getTimeFactor(openResp);
            if (Session.protocolVersion.getValue() != openResp.getServerProtocolVersion().getValue()) {
                logger.warn("Protocol differ, Client version is {}}, but Server version is {}", (Object)Session.protocolVersion.getValue(), (Object)openResp.getServerProtocolVersion().getValue());
                if (openResp.getServerProtocolVersion().getValue() == 0) {
                    throw new TException(String.format("Protocol not supported, Client version is %s, but Server version is %s", Session.protocolVersion.getValue(), openResp.getServerProtocolVersion().getValue()));
                }
            }
            this.sessionId = openResp.getSessionId();
            this.statementId = this.client.requestStatementId(this.sessionId);
        }
        catch (StatementExecutionException e) {
            this.transport.close();
            throw e;
        }
        catch (Exception e) {
            this.transport.close();
            throw new IoTDBConnectionException(e);
        }
    }

    private void initClusterConn() throws IoTDBConnectionException {
        Iterator<TEndPoint> iterator = this.endPointList.iterator();
        if (iterator.hasNext()) {
            TEndPoint tEndPoint = iterator.next();
            try {
                this.session.defaultEndPoint = tEndPoint;
                this.init(tEndPoint, this.session.useSSL, this.session.trustStore, this.session.trustStorePwd);
            }
            catch (IoTDBConnectionException e) {
                if (!this.reconnect()) {
                    logger.error("Cluster has no nodes to connect");
                    throw new IoTDBConnectionException(this.logForReconnectionFailure());
                }
            }
            catch (StatementExecutionException e) {
                throw new IoTDBConnectionException(e.getMessage());
            }
        }
    }

    public void close() throws IoTDBConnectionException {
        if (!this.transport.isOpen()) {
            return;
        }
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionId);
        try {
            this.client.closeSession(req);
        }
        catch (TException e) {
            throw new IoTDBConnectionException("Error occurs when closing session at server. Maybe server is down.", e);
        }
        finally {
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    public IClientRPCService.Iface getClient() {
        return this.client;
    }

    protected void setTimeZone(String zoneId) throws StatementExecutionException, IoTDBConnectionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            TSSetTimeZoneReq req = new TSSetTimeZoneReq(this.sessionId, zoneId);
            return this.client.setTimeZone(req);
        }).getResult();
        RpcUtils.verifySuccess(status);
        this.setTimeZoneOfSession(zoneId);
    }

    protected void setTimeZoneOfSession(String zoneId) {
        this.zoneId = ZoneId.of(zoneId);
    }

    protected String getTimeZone() {
        if (this.zoneId == null) {
            this.zoneId = ZoneId.systemDefault();
        }
        return this.zoneId.toString();
    }

    protected void setStorageGroup(String storageGroup) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> this.client.setStorageGroup(this.sessionId, storageGroup)).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void deleteStorageGroups(List<String> storageGroups) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> this.client.deleteStorageGroups(this.sessionId, storageGroups)).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void createTimeseries(TSCreateTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.createTimeseries(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void createAlignedTimeseries(TSCreateAlignedTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.createAlignedTimeseries(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void createMultiTimeseries(TSCreateMultiTimeseriesReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.createMultiTimeseries(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkTimeseriesExists(String path, long timeout) throws IoTDBConnectionException, StatementExecutionException {
        SessionDataSet dataSet = null;
        try {
            try {
                dataSet = this.executeQueryStatement(String.format("SHOW TIMESERIES %s", path), timeout);
            }
            catch (RedirectException e) {
                throw new StatementExecutionException("need to redirect query, should not see this.", e);
            }
            boolean bl = dataSet.hasNext();
            return bl;
        }
        finally {
            if (dataSet != null) {
                dataSet.closeOperationHandle();
            }
        }
    }

    protected SessionDataSet executeQueryStatement(String sql, long timeout) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        execReq.setFetchSize(this.session.fetchSize);
        execReq.setTimeout(timeout);
        execReq.setEnableRedirectQuery(this.enableRedirect);
        RetryResult<TSExecuteStatementResp> result = this.callWithRetryAndReconnect(() -> {
            execReq.setSessionId(this.sessionId);
            execReq.setStatementId(this.statementId);
            return this.client.executeQueryStatementV2(execReq);
        }, TSExecuteStatementResp::getStatus);
        TSExecuteStatementResp execResp = result.getResult();
        if (result.getRetryAttempts() == 0) {
            RpcUtils.verifySuccessWithRedirection(execResp.getStatus());
        } else {
            RpcUtils.verifySuccess(execResp.getStatus());
        }
        return new SessionDataSet(sql, execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.statementId, this.client, this.sessionId, execResp.queryResult, execResp.isIgnoreTimeStamp(), timeout, execResp.moreData, this.session.fetchSize, this.zoneId, this.timeFactor, execResp.isSetTableModel() && execResp.isTableModel(), execResp.getColumnIndex2TsBlockColumnIndexList());
    }

    protected void executeNonQueryStatement(String sql) throws IoTDBConnectionException, StatementExecutionException {
        TSExecuteStatementReq request = new TSExecuteStatementReq(this.sessionId, sql, this.statementId);
        this.callWithRetryAndVerify(() -> this.executeNonQueryStatementInternal(request));
    }

    private TSStatus executeNonQueryStatementInternal(TSExecuteStatementReq request) throws TException {
        request.setSessionId(this.sessionId);
        request.setStatementId(this.statementId);
        TSExecuteStatementResp resp = this.client.executeUpdateStatementV2(request);
        if (resp.isSetDatabase()) {
            String dbName = resp.getDatabase();
            this.session.changeDatabase(dbName);
            this.database = dbName;
        }
        if (resp.isSetTableModel()) {
            String sqlDialect;
            String string = sqlDialect = resp.tableModel ? "table" : "tree";
            if (!sqlDialect.equalsIgnoreCase(this.sqlDialect)) {
                this.session.changeSqlDialect(sqlDialect);
                this.sqlDialect = sqlDialect;
            }
        }
        return resp.status;
    }

    protected SessionDataSet executeRawDataQuery(List<String> paths, long startTime, long endTime, long timeOut) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSRawDataQueryReq execReq = new TSRawDataQueryReq(this.sessionId, paths, startTime, endTime, this.statementId);
        execReq.setFetchSize(this.session.fetchSize);
        execReq.setTimeout(timeOut);
        execReq.setEnableRedirectQuery(this.enableRedirect);
        RetryResult<TSExecuteStatementResp> result = this.callWithRetryAndReconnect(() -> {
            execReq.setSessionId(this.sessionId);
            execReq.setStatementId(this.statementId);
            return this.client.executeRawDataQueryV2(execReq);
        }, TSExecuteStatementResp::getStatus);
        TSExecuteStatementResp execResp = result.getResult();
        if (result.getRetryAttempts() == 0) {
            RpcUtils.verifySuccessWithRedirection(execResp.getStatus());
        } else {
            RpcUtils.verifySuccess(execResp.getStatus());
        }
        return new SessionDataSet("", execResp.getColumns(), execResp.getDataTypeList(), execResp.columnNameIndexMap, execResp.getQueryId(), this.statementId, this.client, this.sessionId, execResp.queryResult, execResp.isIgnoreTimeStamp(), execResp.moreData, this.zoneId, this.timeFactor, execResp.isSetTableModel() && execResp.isTableModel(), execResp.getColumnIndex2TsBlockColumnIndexList());
    }

    protected SessionDataSet executeLastDataQueryForOnePrefixPath(List<String> prefixes) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSFastLastDataQueryForOnePrefixPathReq req = new TSFastLastDataQueryForOnePrefixPathReq(this.sessionId, prefixes, this.statementId);
        req.setFetchSize(this.session.fetchSize);
        req.setEnableRedirectQuery(this.enableRedirect);
        RetryResult<TSExecuteStatementResp> result = this.callWithReconnect(() -> {
            req.setSessionId(this.sessionId);
            req.setStatementId(this.statementId);
            return this.client.executeFastLastDataQueryForOnePrefixPath(req);
        });
        TSExecuteStatementResp tsExecuteStatementResp = result.getResult();
        if (result.getRetryAttempts() == 0) {
            RpcUtils.verifySuccessWithRedirection(tsExecuteStatementResp.getStatus());
        } else {
            RpcUtils.verifySuccess(tsExecuteStatementResp.getStatus());
        }
        return new SessionDataSet("", tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.getQueryId(), this.statementId, this.client, this.sessionId, tsExecuteStatementResp.queryResult, tsExecuteStatementResp.isIgnoreTimeStamp(), tsExecuteStatementResp.moreData, this.zoneId, this.timeFactor, false, tsExecuteStatementResp.getColumnIndex2TsBlockColumnIndexList());
    }

    protected Pair<SessionDataSet, TEndPoint> executeLastDataQueryForOneDevice(String db, String device, List<String> sensors, boolean isLegalPathNodes, long timeOut) throws StatementExecutionException, IoTDBConnectionException {
        TSFastLastDataQueryForOneDeviceReq req = new TSFastLastDataQueryForOneDeviceReq(this.sessionId, db, device, sensors, this.statementId);
        req.setFetchSize(this.session.fetchSize);
        req.setEnableRedirectQuery(this.enableRedirect);
        req.setLegalPathNodes(isLegalPathNodes);
        req.setTimeout(timeOut);
        TEndPoint redirectedEndPoint = null;
        RetryResult<TSExecuteStatementResp> result = this.callWithRetryAndReconnect(() -> {
            req.setSessionId(this.sessionId);
            req.setStatementId(this.statementId);
            return this.client.executeFastLastDataQueryForOneDeviceV2(req);
        }, TSExecuteStatementResp::getStatus);
        TSExecuteStatementResp tsExecuteStatementResp = result.getResult();
        if (result.getRetryAttempts() == 0) {
            try {
                RpcUtils.verifySuccessWithRedirection(tsExecuteStatementResp.getStatus());
            }
            catch (RedirectException e) {
                redirectedEndPoint = e.getEndPoint();
            }
        } else {
            RpcUtils.verifySuccess(tsExecuteStatementResp.getStatus());
        }
        return new Pair<SessionDataSet, TEndPoint>(new SessionDataSet("", tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.getQueryId(), this.statementId, this.client, this.sessionId, tsExecuteStatementResp.queryResult, tsExecuteStatementResp.isIgnoreTimeStamp(), tsExecuteStatementResp.moreData, this.zoneId, this.timeFactor, tsExecuteStatementResp.isSetTableModel() && tsExecuteStatementResp.isTableModel(), tsExecuteStatementResp.getColumnIndex2TsBlockColumnIndexList()), redirectedEndPoint);
    }

    protected SessionDataSet executeLastDataQuery(List<String> paths, long time, long timeOut) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSLastDataQueryReq tsLastDataQueryReq = new TSLastDataQueryReq(this.sessionId, paths, time, this.statementId);
        tsLastDataQueryReq.setFetchSize(this.session.fetchSize);
        tsLastDataQueryReq.setEnableRedirectQuery(this.enableRedirect);
        tsLastDataQueryReq.setTimeout(timeOut);
        RetryResult<TSExecuteStatementResp> result = this.callWithRetryAndReconnect(() -> {
            tsLastDataQueryReq.setSessionId(this.sessionId);
            tsLastDataQueryReq.setStatementId(this.statementId);
            return this.client.executeLastDataQueryV2(tsLastDataQueryReq);
        }, TSExecuteStatementResp::getStatus);
        TSExecuteStatementResp tsExecuteStatementResp = result.getResult();
        if (result.getRetryAttempts() == 0) {
            RpcUtils.verifySuccessWithRedirection(tsExecuteStatementResp.getStatus());
        } else {
            RpcUtils.verifySuccess(tsExecuteStatementResp.getStatus());
        }
        return new SessionDataSet("", tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.getQueryId(), this.statementId, this.client, this.sessionId, tsExecuteStatementResp.queryResult, tsExecuteStatementResp.isIgnoreTimeStamp(), tsExecuteStatementResp.moreData, this.zoneId, this.timeFactor, tsExecuteStatementResp.isSetTableModel() && tsExecuteStatementResp.isTableModel(), tsExecuteStatementResp.getColumnIndex2TsBlockColumnIndexList());
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        return this.executeAggregationQuery(req);
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        req.setStartTime(startTime);
        req.setEndTime(endTime);
        return this.executeAggregationQuery(req);
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        req.setStartTime(startTime);
        req.setEndTime(endTime);
        req.setInterval(interval);
        return this.executeAggregationQuery(req);
    }

    protected SessionDataSet executeAggregationQuery(List<String> paths, List<TAggregationType> aggregations, long startTime, long endTime, long interval, long slidingStep) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        TSAggregationQueryReq req = this.createAggregationQueryReq(paths, aggregations);
        req.setStartTime(startTime);
        req.setEndTime(endTime);
        req.setInterval(interval);
        req.setSlidingStep(slidingStep);
        return this.executeAggregationQuery(req);
    }

    private SessionDataSet executeAggregationQuery(TSAggregationQueryReq tsAggregationQueryReq) throws StatementExecutionException, IoTDBConnectionException, RedirectException {
        RetryResult<TSExecuteStatementResp> result = this.callWithRetryAndReconnect(() -> {
            tsAggregationQueryReq.setSessionId(this.sessionId);
            tsAggregationQueryReq.setStatementId(this.statementId);
            return this.client.executeAggregationQueryV2(tsAggregationQueryReq);
        }, TSExecuteStatementResp::getStatus);
        TSExecuteStatementResp tsExecuteStatementResp = result.getResult();
        if (result.getRetryAttempts() == 0) {
            RpcUtils.verifySuccessWithRedirection(tsExecuteStatementResp.getStatus());
        } else {
            RpcUtils.verifySuccess(tsExecuteStatementResp.getStatus());
        }
        return new SessionDataSet("", tsExecuteStatementResp.getColumns(), tsExecuteStatementResp.getDataTypeList(), tsExecuteStatementResp.columnNameIndexMap, tsExecuteStatementResp.getQueryId(), this.statementId, this.client, this.sessionId, tsExecuteStatementResp.queryResult, tsExecuteStatementResp.isIgnoreTimeStamp(), tsExecuteStatementResp.moreData, this.zoneId, this.timeFactor, tsExecuteStatementResp.isSetTableModel() && tsExecuteStatementResp.isTableModel(), tsExecuteStatementResp.getColumnIndex2TsBlockColumnIndexList());
    }

    private TSAggregationQueryReq createAggregationQueryReq(List<String> paths, List<TAggregationType> aggregations) {
        TSAggregationQueryReq req = new TSAggregationQueryReq(this.sessionId, this.statementId, paths, aggregations);
        req.setFetchSize(this.session.getFetchSize());
        req.setTimeout(this.session.getQueryTimeout());
        return req;
    }

    protected void insertRecord(TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirection(() -> this.insertRecordInternal(request));
    }

    private TSStatus insertRecordInternal(TSInsertRecordReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertRecord(request);
    }

    protected void insertRecord(TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirection(() -> this.insertRecordInternal(request));
    }

    private TSStatus insertRecordInternal(TSInsertStringRecordReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertStringRecord(request);
    }

    protected void insertRecords(TSInsertRecordsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirectionForMultipleDevices(() -> this.insertRecordsInternal(request), request::getPrefixPaths);
    }

    private TSStatus insertRecordsInternal(TSInsertRecordsReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertRecords(request);
    }

    protected void insertRecords(TSInsertStringRecordsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirectionForMultipleDevices(() -> this.insertRecordsInternal(request), request::getPrefixPaths);
    }

    private TSStatus insertRecordsInternal(TSInsertStringRecordsReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertStringRecords(request);
    }

    protected void insertRecordsOfOneDevice(TSInsertRecordsOfOneDeviceReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirection(() -> this.insertRecordsOfOneDeviceInternal(request));
    }

    private TSStatus insertRecordsOfOneDeviceInternal(TSInsertRecordsOfOneDeviceReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertRecordsOfOneDevice(request);
    }

    protected void insertStringRecordsOfOneDevice(TSInsertStringRecordsOfOneDeviceReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirection(() -> this.insertStringRecordsOfOneDeviceInternal(request));
    }

    private TSStatus insertStringRecordsOfOneDeviceInternal(TSInsertStringRecordsOfOneDeviceReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertStringRecordsOfOneDevice(request);
    }

    private void callWithRetryAndVerifyWithRedirectionForMultipleDevices(TFunction<TSStatus> function, Supplier<List<String>> pathSupplier) throws StatementExecutionException, RedirectException, IoTDBConnectionException {
        RetryResult<TSStatus> result = this.callWithRetry(function);
        TSStatus status = result.getResult();
        if (status != null) {
            if (result.getRetryAttempts() == 0) {
                RpcUtils.verifySuccessWithRedirectionForMultiDevices(status, pathSupplier.get());
            } else {
                RpcUtils.verifySuccess(status);
            }
        } else {
            if (result.getException() != null) {
                throw new IoTDBConnectionException(result.getException());
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    private void callWithRetryAndVerifyWithRedirection(TFunction<TSStatus> function) throws StatementExecutionException, RedirectException, IoTDBConnectionException {
        RetryResult<TSStatus> result = this.callWithRetry(function);
        TSStatus status = result.getResult();
        if (status != null) {
            if (result.getRetryAttempts() == 0) {
                RpcUtils.verifySuccessWithRedirection(status);
            } else {
                RpcUtils.verifySuccess(status);
            }
        } else {
            if (result.getException() != null) {
                throw new IoTDBConnectionException(result.getException());
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    protected void insertTablet(TSInsertTabletReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirection(() -> this.insertTabletInternal(request));
    }

    private TSStatus insertTabletInternal(TSInsertTabletReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertTablet(request);
    }

    protected void insertTablets(TSInsertTabletsReq request) throws IoTDBConnectionException, StatementExecutionException, RedirectException {
        this.callWithRetryAndVerifyWithRedirectionForMultipleDevices(() -> this.insertTabletsInternal(request), request::getPrefixPaths);
    }

    private TSStatus insertTabletsInternal(TSInsertTabletsReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.insertTablets(request);
    }

    protected void deleteTimeseries(List<String> paths) throws IoTDBConnectionException, StatementExecutionException {
        this.callWithRetryAndVerify(() -> this.client.deleteTimeseries(this.sessionId, paths));
    }

    public void deleteData(TSDeleteDataReq request) throws IoTDBConnectionException, StatementExecutionException {
        this.callWithRetryAndVerify(() -> this.deleteDataInternal(request));
    }

    private void callWithRetryAndVerify(TFunction<TSStatus> rpc) throws IoTDBConnectionException, StatementExecutionException {
        RetryResult<TSStatus> result = this.callWithRetry(rpc);
        if (result.getResult() == null) {
            if (result.getException() != null) {
                throw new IoTDBConnectionException(result.getException());
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
        RpcUtils.verifySuccess(result.getResult());
    }

    private RetryResult<TSStatus> callWithRetry(TFunction<TSStatus> rpc) {
        int i;
        TException lastTException = null;
        TSStatus status = null;
        for (i = 0; i <= this.maxRetryCount; ++i) {
            if (i > 0) {
                lastTException = null;
                status = null;
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn("Thread {} was interrupted during retry {} with wait time {} ms. Exiting retry loop.", Thread.currentThread().getName(), i, this.retryIntervalInMs);
                    break;
                }
                if (!this.reconnect()) continue;
            }
            try {
                status = rpc.run();
                if (!status.isSetNeedRetry() || !status.isNeedRetry()) break;
                continue;
            }
            catch (TException e) {
                lastTException = e;
            }
        }
        return new RetryResult<Object>(status, lastTException, i);
    }

    private RetryResult<TSStatus> callWithRetryAndReconnect(TFunction<TSStatus> rpc) {
        return this.callWithRetryAndReconnect(rpc, status -> status.isSetNeedRetry() && status.isNeedRetry(), status -> status.getCode() == TSStatusCode.PLAN_FAILED_NETWORK_PARTITION.getStatusCode());
    }

    private <T> RetryResult<T> callWithRetryAndReconnect(TFunction<T> rpc, Function<T, TSStatus> statusGetter) {
        return this.callWithRetryAndReconnect(rpc, t -> {
            TSStatus status = (TSStatus)statusGetter.apply(t);
            return status.isSetNeedRetry() && status.isNeedRetry();
        }, t -> ((TSStatus)statusGetter.apply(t)).getCode() == TSStatusCode.PLAN_FAILED_NETWORK_PARTITION.getStatusCode());
    }

    private <T> RetryResult<T> callWithRetryAndReconnect(TFunction<T> rpc, Predicate<T> shouldRetry, Predicate<T> forceReconnect) {
        int retryAttempt;
        TException lastTException = null;
        Object result = null;
        int maxRetryCountRead = 10;
        for (retryAttempt = 0; retryAttempt <= maxRetryCountRead; ++retryAttempt) {
            try {
                result = rpc.run();
                lastTException = null;
            }
            catch (TException e) {
                result = null;
                lastTException = e;
            }
            if (result != null && !shouldRetry.test(result)) {
                return new RetryResult<Object>(result, null, retryAttempt);
            }
            logger.debug("Retry attempt #{}, result {}, exception {}", retryAttempt, result, lastTException);
            if (lastTException != null || !this.availableNodes.get().contains(this.endPoint) || result != null && forceReconnect.test(result)) {
                logger.debug("Retry attempt #{}, Reconnecting to other datanode", (Object)retryAttempt);
                this.reconnect();
            }
            try {
                TimeUnit.MILLISECONDS.sleep(this.retryIntervalInMs);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Thread {} was interrupted during retry {} with wait time {} ms. Exiting retry loop.", Thread.currentThread().getName(), retryAttempt, this.retryIntervalInMs);
                break;
            }
        }
        return new RetryResult<Object>(result, lastTException, retryAttempt);
    }

    private TSStatus deleteDataInternal(TSDeleteDataReq request) throws TException {
        request.setSessionId(this.sessionId);
        return this.client.deleteData(request);
    }

    protected void testInsertRecord(TSInsertStringRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.testInsertStringRecord(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void testInsertRecord(TSInsertRecordReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.testInsertRecord(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    public void testInsertRecords(TSInsertStringRecordsReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.testInsertStringRecords(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    public void testInsertRecords(TSInsertRecordsReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.testInsertRecords(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void testInsertTablet(TSInsertTabletReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.testInsertTablet(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void testInsertTablets(TSInsertTabletsReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.testInsertTablets(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    public boolean reconnect() {
        boolean connectedSuccess = false;
        SecureRandom random = new SecureRandom();
        for (int i = 1; i <= 3; ++i) {
            if (this.transport != null) {
                this.transport.close();
                this.endPointList = this.availableNodes.get();
                int currHostIndex = random.nextInt(this.endPointList.size());
                int tryHostNum = 0;
                for (int j = currHostIndex; j < this.endPointList.size() && tryHostNum != this.endPointList.size(); ++tryHostNum, ++j) {
                    this.endPoint = this.endPointList.get(j);
                    if (j == this.endPointList.size() - 1) {
                        j = -1;
                    }
                    try {
                        this.init(this.endPoint, this.session.useSSL, this.session.trustStore, this.session.trustStorePwd);
                        connectedSuccess = true;
                        break;
                    }
                    catch (IoTDBConnectionException e) {
                        logger.warn("The current node may have been down {}, try next node", (Object)this.endPoint);
                        continue;
                    }
                    catch (StatementExecutionException e) {
                        logger.warn("login in failed, because {}", (Object)e.getMessage());
                        break;
                    }
                }
            }
            if (!connectedSuccess) continue;
            this.session.removeBrokenSessionConnection(this);
            this.session.defaultEndPoint = this.endPoint;
            this.session.setDefaultSessionConnection(this);
            if (this.session.endPointToSessionConnection == null) {
                this.session.endPointToSessionConnection = new ConcurrentHashMap<TEndPoint, SessionConnection>();
            }
            this.session.endPointToSessionConnection.compute(this.session.defaultEndPoint, (k, v) -> {
                if (v != null && v.transport != null && v.transport.isOpen()) {
                    try {
                        v.close();
                    }
                    catch (IoTDBConnectionException e) {
                        logger.warn("close connection failed, {}", (Object)e.getMessage());
                    }
                }
                return this;
            });
            break;
        }
        return connectedSuccess;
    }

    protected void createSchemaTemplate(TSCreateSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.createSchemaTemplate(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void appendSchemaTemplate(TSAppendSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.appendSchemaTemplate(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void pruneSchemaTemplate(TSPruneSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.pruneSchemaTemplate(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected TSQueryTemplateResp querySchemaTemplate(TSQueryTemplateReq req) throws StatementExecutionException, IoTDBConnectionException {
        TSQueryTemplateResp execResp = this.callWithRetryAndReconnect(() -> {
            req.setSessionId(this.sessionId);
            return this.client.querySchemaTemplate(req);
        }, TSQueryTemplateResp::getStatus).getResult();
        RpcUtils.verifySuccess(execResp.getStatus());
        return execResp;
    }

    protected void setSchemaTemplate(TSSetSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.setSchemaTemplate(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void unsetSchemaTemplate(TSUnsetSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.unsetSchemaTemplate(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void dropSchemaTemplate(TSDropSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.dropSchemaTemplate(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected void createTimeseriesUsingSchemaTemplate(TCreateTimeseriesUsingSchemaTemplateReq request) throws IoTDBConnectionException, StatementExecutionException {
        TSStatus status = this.callWithRetryAndReconnect(() -> {
            request.setSessionId(this.sessionId);
            return this.client.createTimeseriesUsingSchemaTemplate(request);
        }).getResult();
        RpcUtils.verifySuccess(status);
    }

    protected TSBackupConfigurationResp getBackupConfiguration() throws IoTDBConnectionException, StatementExecutionException {
        TSBackupConfigurationResp execResp = this.callWithRetryAndReconnect(() -> this.client.getBackupConfiguration(), TSBackupConfigurationResp::getStatus).getResult();
        RpcUtils.verifySuccess(execResp.getStatus());
        return execResp;
    }

    private <T> RetryResult<T> callWithReconnect(TFunction<T> supplier) throws IoTDBConnectionException {
        try {
            T ret = supplier.run();
            return new RetryResult<T>(ret, null, 0);
        }
        catch (TException e) {
            if (this.reconnect()) {
                try {
                    T ret = supplier.run();
                    return new RetryResult<T>(ret, null, 1);
                }
                catch (TException tException) {
                    throw new IoTDBConnectionException(tException);
                }
            }
            throw new IoTDBConnectionException(this.logForReconnectionFailure());
        }
    }

    public TSConnectionInfoResp fetchAllConnections() throws IoTDBConnectionException {
        return this.callWithRetryAndReconnect(() -> this.client.fetchAllConnectionsInfo(), resp -> false, resp -> false).getResult();
    }

    public boolean isEnableRedirect() {
        return this.enableRedirect;
    }

    public void setEnableRedirect(boolean enableRedirect) {
        this.enableRedirect = enableRedirect;
    }

    public TEndPoint getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(TEndPoint endPoint) {
        this.endPoint = endPoint;
    }

    public String logForReconnectionFailure() {
        if (this.endPointList == null) {
            return MSG_RECONNECTION_FAIL;
        }
        StringJoiner urls = new StringJoiner(",");
        for (TEndPoint end : this.endPointList) {
            StringJoiner url = new StringJoiner(":");
            url.add(end.getIp());
            url.add(String.valueOf(end.getPort()));
            urls.add(url.toString());
        }
        return MSG_RECONNECTION_FAIL.concat(urls.toString());
    }

    public String toString() {
        return "SessionConnection{ endPoint=" + this.endPoint + "}";
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getStatementId() {
        return this.statementId;
    }

    private static interface TFunction<T> {
        public T run() throws TException;
    }

    private static class RetryResult<T> {
        private final T result;
        private final TException exception;
        private final int retryAttempts;

        public RetryResult(T result, TException exception, int retryAttempts) {
            Preconditions.checkArgument(result == null || exception == null);
            this.result = result;
            this.exception = exception;
            this.retryAttempts = retryAttempts;
        }

        public int getRetryAttempts() {
            return this.retryAttempts;
        }

        public TException getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }
    }
}

